

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0



#line 18 "pipe.d"
#include <string.h> 

#define	CLASS	Pipe_c
#define	ivType	Pipe_iv_t

#include "generics.h"

object	Pipe_c;


#line 28 "pipe.c"
typedef struct  _Pipe_iv_t  {
	object iObj;
	char * iName;
	char * iBuf;
	int iBufsiz;
	char * iWptr;
	char * iRptr;
	object iRblk;
	object iWblk;
	int iRblock;
	int iWblock;
	struct _Pipe_iv_t * iNext;
}	Pipe_iv_t;


#line 44 "pipe.c"
typedef struct  _Pipe_cv_t  {
	struct _Pipe_iv_t * cMpl;
}	Pipe_cv_t;

static	Pipe_cv_t	*Pipe_cv;



#line 38 "pipe.d"
cmeth objrtn New(object self, char *name, int bufsiz)
{ 
	object obj = oSuper(Pipe_c, gNew, self)(self); 
	ivType *iv = ivPtr(obj); 

	iv->iObj = obj; 
	if (name) { 
		iv->iName = Tnalloc(char, strlen(name)+1); 
		strcpy(iv->iName, name); 
	} 
	iv->iBuf = Tnalloc(char, bufsiz); 
	iv->iBufsiz = bufsiz; 
	iv->iWptr = iv->iRptr = iv->iBuf; 
	iv->iNext = Pipe_cv->cMpl; 
	Pipe_cv->cMpl = iv; 
	return obj; 
} 

cmeth objrtn Pipe_cm_gNew(object self)
{ 
	return New(self, NULL, 128); 
} 

imeth int Pipe_im_gWrite(object self, char *buf, unsigned sz)
{ Pipe_iv_t *iv = GetIVs(Pipe, self);
	int room, rroom, bytes, w=0; 

	if (iv->iWblk) 
		return 0; 
	while (sz) { 


		room = iv->iBufsiz - (iv->iWptr - iv->iBuf); 



		if (room < (int) sz) { 
			rroom = iv->iRptr - iv->iBuf; 
			if (rroom) { 
				bytes = iv->iWptr - iv->iRptr; 
				memmove(iv->iBuf, iv->iRptr, bytes); 
				iv->iRptr = iv->iBuf; 
				iv->iWptr = iv->iBuf + bytes; 
				room = iv->iBufsiz - (iv->iWptr - iv->iBuf); 
			} 
		} 

		bytes = (int) sz > room ? room : (int) sz; 
		if (bytes) { 
			memcpy(iv->iWptr, buf, bytes); 
			iv->iWptr += bytes; 
			buf += bytes; 
			sz -= bytes; 
			w += bytes; 
			if (iv->iRblk) 
				gRelease(iv->iRblk, 0); 
		} 


		room = iv->iBufsiz - (iv->iWptr - iv->iRptr); 
		if (sz && !room && iv->iWblock) { 
			iv->iWblk = gFindStr(Thread, NULL); 
			gHold(iv->iWblk); 
			iv->iWblk = NULL; 
		} 
		if (!iv->iWblock) 
			break; 
	} 
	return(w); 
} 

imeth int Pipe_im_gRead(object self, char *buf, unsigned sz)
{ Pipe_iv_t *iv = GetIVs(Pipe, self);
	int ba; 
	int bg; 
	int tr=0; 

	if (iv->iRblk) 
		return 0; 
	while (sz) { 
		ba = iv->iWptr - iv->iRptr; 
		bg = ba < (int) sz ? ba : (int) sz; 
		if (bg) { 
			memcpy(buf, iv->iRptr, bg); 
			buf += bg; 
			iv->iRptr += bg; 
			sz -= bg; 
			tr += bg; 
			if (iv->iWblk) 
				gRelease(iv->iWblk, 0); 
		} 

		ba = iv->iWptr - iv->iRptr; 
		if (sz && !ba && iv->iRblock) { 
			iv->iRblk = gFindStr(Thread, NULL); 
			gHold(iv->iRblk); 
			iv->iRblk = NULL; 
		} 
		if (!iv->iRblock) 
			break; 
	} 
	return(tr); 
} 

imeth char * Pipe_im_gGets(object self, char *buf, int sz)
{ Pipe_iv_t *iv = GetIVs(Pipe, self);
	int ba; 
	int bg; 
	int tr=0; 

	if (!(iv->iWptr - iv->iRptr) && !iv->iRblock || iv->iRblk || sz <= 0) 
		return NULL; 
	if (sz-- == 1) { 
		*buf = '\0'; 
		return buf; 
	} 
	while (sz) { 
		ba = iv->iWptr - iv->iRptr; 
		for (bg=0 ; bg < ba && bg < sz && iv->iRptr[bg++] != '\n' ; ); 
		if (iv->iRptr[bg-1] == '\n') 
			sz = bg; 
		if (bg) { 
			memcpy(buf, iv->iRptr, bg); 
			buf += bg; 
			iv->iRptr += bg; 
			sz -= bg; 
			tr += bg; 
			if (iv->iWblk) 
				gRelease(iv->iWblk, 0); 
		} 

		ba = iv->iWptr - iv->iRptr; 
		if (sz && !ba && iv->iRblock) { 
			iv->iRblk = gFindStr(Thread, NULL); 
			gHold(iv->iRblk); 
			iv->iRblk = NULL; 
		} 
		if (!iv->iRblock) 
			break; 
	} 
	buf[tr] = '\0'; 
	return buf; 
} 

imeth objrtn Pipe_im_gDispose(object self)
{ Pipe_iv_t *iv = GetIVs(Pipe, self);
	ivType *t, *pt; 

	if (iv->iRblk || iv->iWblk) 
		return NULL; 
	for (t=Pipe_cv->cMpl, pt=NULL ; t ; pt=t, t=t->iNext) 
		if (t == iv) { 
		if (pt) 
			pt->iNext = t->iNext; 
		else 
			Pipe_cv->cMpl = t->iNext; 
		break; 
	} 
	if (iv->iName) { 
		free(iv->iName); 
		iv->iName = NULL; 
	} 
	if (iv->iBuf) { 
		free(iv->iBuf); 
		iv->iBuf = NULL; 
	} 
	return oSuper(Pipe_c, gDispose, self)(self); 
} 

cmeth objrtn Pipe_cm_gFindStr(object self, char *name)
{ 
	ivType *p; 

	USE(self); 
	if (!name) 
		return NULL; 
	for (p=Pipe_cv->cMpl ; p ; p=p->iNext) 
		if (p->iName && !strcmp(p->iName, name)) 
		return p->iObj; 
	return NULL; 
} 

imeth long Pipe_im_gLength(object self)
{ Pipe_iv_t *iv = GetIVs(Pipe, self);
#if 0 
		if (iv->iRblock && !(iv->iWptr - iv->iRptr)) { 
		iv->iRblk = gFindStr(Thread, NULL); 
		gHold(iv->iRblk); 
		iv->iRblk = NULL; 
	} 
#endif 
		return iv->iWptr - iv->iRptr; 
} 

imeth int Pipe_im_gRoom(object self)
{ Pipe_iv_t *iv = GetIVs(Pipe, self);
#if 0 
		if (iv->iWblock && !(iv->iBufsiz - (iv->iWptr - iv->iRptr))) { 
		iv->iWblk = gFindStr(Thread, NULL); 
		gHold(iv->iWblk); 
		iv->iWblk = NULL; 
	} 
#endif 
		return iv->iBufsiz - (iv->iWptr - iv->iRptr); 
} 

imeth int Pipe_im_gSize(object self)
{ Pipe_iv_t *iv = GetIVs(Pipe, self);
	return iv->iBufsiz; 
} 

imeth char * Pipe_im_gName(object self)
{ Pipe_iv_t *iv = GetIVs(Pipe, self);
	return iv->iName; 
} 

imeth objrtn Pipe_im_gMode(object self, int rblock, int wblock)
{ Pipe_iv_t *iv = GetIVs(Pipe, self);
	iv->iRblock = rblock; 
	iv->iWblock = wblock; 
	return self; 
} 

imeth long Pipe_im_gAdvance(object self, long sz)
{ Pipe_iv_t *iv = GetIVs(Pipe, self);
	int ba; 
	int bg; 
	long tr=0; 

	if (iv->iRblk) 
		return 0; 
	while (sz) { 
		ba = iv->iWptr - iv->iRptr; 
		bg = (long) ba < sz ? ba : (int) sz; 
		if (bg) { 
			iv->iRptr += bg; 
			sz -= bg; 
			tr += bg; 
			if (iv->iWblk) 
				gRelease(iv->iWblk, 0); 
		} 

		ba = iv->iWptr - iv->iRptr; 
		if (sz && !ba && iv->iRblock) { 
			iv->iRblk = gFindStr(Thread, NULL); 
			gHold(iv->iRblk); 
			iv->iRblk = NULL; 
		} 
		if (!iv->iRblock) 
			break; 
	} 
	return(tr); 
} 

imeth long Pipe_im_gPosition(object self)
{ 
	USE(self); 
	return 0L; 
} 

imeth int Pipe_im_gEndOfStream(object self)
{ Pipe_iv_t *iv = GetIVs(Pipe, self);
	return !(iv->iWptr - iv->iRptr); 
} 


#line 320 "pipe.c"

objrtn	Pipe_initialize(void)
{
	static  CRITICALSECTION  cs;
	static  int volatile once = 0;

	ENTERCRITICALSECTION(_CI_CS_);
	if (!once) {
		INITIALIZECRITICALSECTION(cs);
		once = 1;
	}
	LEAVECRITICALSECTION(_CI_CS_);

	ENTERCRITICALSECTION(cs);

	if (Pipe_c) {
		LEAVECRITICALSECTION(cs);
		return Pipe_c;
	}
	INHIBIT_THREADER;
	Stream_initialize();
	if (Pipe_c)  {
		ENABLE_THREADER;
		LEAVECRITICALSECTION(cs);
		return Pipe_c;
	}
	Pipe_c = gNewClass(Class, "Pipe", sizeof(Pipe_iv_t), sizeof(Pipe_cv_t), Stream, END);
	cMethodFor(Pipe, gNewWithStrInt, New);
	cMethodFor(Pipe, gFindStr, Pipe_cm_gFindStr);
	cMethodFor(Pipe, gNew, Pipe_cm_gNew);
	iMethodFor(Pipe, gPosition, Pipe_im_gPosition);
	iMethodFor(Pipe, gLength, Pipe_im_gLength);
	iMethodFor(Pipe, gWrite, Pipe_im_gWrite);
	iMethodFor(Pipe, gEndOfStream, Pipe_im_gEndOfStream);
	iMethodFor(Pipe, gAdvance, Pipe_im_gAdvance);
	iMethodFor(Pipe, gSize, Pipe_im_gSize);
	iMethodFor(Pipe, gDispose, Pipe_im_gDispose);
	iMethodFor(Pipe, gName, Pipe_im_gName);
	iMethodFor(Pipe, gGets, Pipe_im_gGets);
	iMethodFor(Pipe, gGCDispose, Pipe_im_gDispose);
	iMethodFor(Pipe, gDeepDispose, Pipe_im_gDispose);
	iMethodFor(Pipe, gRead, Pipe_im_gRead);
	iMethodFor(Pipe, gRoom, Pipe_im_gRoom);
	iMethodFor(Pipe, gMode, Pipe_im_gMode);

	Pipe_cv = GetCVs(Pipe);

	ENABLE_THREADER;

	LEAVECRITICALSECTION(cs);

	return Pipe_c;
}



