
/*                                      
 *
 *      Copyright (c) 1993-1996 Algorithms Corporation
 *      3020 Liberty Hills Drive
 *      Franklin, TN 37067
 *
 *      ALL RIGHTS RESERVED.
 *
 *      
 *      
 */




defclass  IntegerDictionary : Set  {
 init:	init_class;
};


#include "set1.h"



#define LTYPE	4	/*  lookup type		*/

static	gLookup_t	Lookup;		/*  locally cached  */

imeth	gAddInt, <vAdd> (int key, value)
{
	ChkArgNul(value, 3);
	return Lookup(self, (object) &key, HT_ADD, 0, LTYPE, value);
}

imeth	gFindValueInt, <vFindValue> (int key)
{
	object	x;

	x = Lookup(self, (object) &key, HT_FIND, 0, LTYPE, NULL);
	return x ? gValue(x) : x;
}

imeth	gFindInt, <vFind> (int key)
{
	return Lookup(self, (object) &key, HT_FIND, 0, LTYPE, NULL);
}

imeth	gChangeValueWithInt, <vChangeValue> (int key, object val)
{
	object	x;
	ChkArgNul(val, 3);
	x = Lookup(self, (object) &key, HT_FIND, 0, LTYPE, NULL);
	return x ? gChangeValue(x, val) : x;
}

imeth	gFindAddInt, <vFindAdd> (int key, value)
{
	ChkArgNul(value, 3);
	return Lookup(self, (object) &key, HT_FINDADD, 0, LTYPE, value);
}

imeth	object	gDispose()
{
	return gDispose1(self);
}

imeth	object	gDisposeAllNodes()
{
	return gDisposeAllNodes1(self);
}

imeth	gRemoveInt, <vRemove> (int key)
{
	return Lookup(self, (object) &key, HT_DELETE, 1, LTYPE, NULL);
}

imeth	gDeepDisposeInt, gDisposeInt (int key)
{
	return Lookup(self, (object) &key, HT_DELETE, 2, LTYPE, NULL);
}

static	void	init_class(void)
{
	Lookup = imcPointer(Set, gLookup);
}



/*                                      
 *
 *      Copyright (c) 1993-1996 Algorithms Corporation
 *      3020 Liberty Hills Drive
 *      Franklin, TN 37067
 *
 *      ALL RIGHTS RESERVED.
 *
 *      
 *      
 */


