
/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */



#include <sys/types.h>
#if	!defined(vms)  &&  !defined(__MWERKS__)
#include <sys/stat.h>
#endif
#ifdef	sparc
#include <unistd.h>
#endif


defclass  File : Stream  {
	iName;
	FILE	*iFP;
 init:	class_init;
};

cmeth	gNew()
{
	return gShouldNotImplement(self, "gNew");
}

cmeth	gOpenFile, <vNew> (char *name, char *mode)
{
	object	obj;
	ivType	*iv;
	FILE	*fp;

	if (IsObj((object) name))
		name = gStringValue((object) name);
	if (IsObj((object) mode))
		mode = gStringValue((object) mode);
	fp = fopen(name, mode);
	if (!fp)
		return NULL;
	obj = gNew(super);
	iv = ivPtr(obj);
	iName = gNewWithStr(String, name);
	iFP = fp;
	return obj;
}

private	cmeth	StreamObject(object self, char *name, FILE *fp)
{
	object	obj;
	ivType	*iv;

	obj = gNew(super);
	iv = ivPtr(obj);
	iName = gNewWithStr(String, name);
	iFP = fp;
	return obj;
}

imeth	object	gDispose, gDeepDispose, gGCDispose ()
{
	fclose(iFP);
	gDispose(iName);
	gDispose(super);
	return NULL;
}

imeth	int	gRead(char *buf, unsigned n)
{
	return fread(buf, 1, n, iFP);
}

imeth	int	gWrite(char *buf, unsigned n)
{
	return fwrite(buf, 1, n, iFP);
}

imeth	char	*gGets(char *buf, int sz)
{
/*	char	*fgets(char *, int, FILE *);  */
	return fgets(buf, sz, iFP);
}

imeth	long	gAdvance(long n)
{
	int	r = fseek(iFP, n, SEEK_CUR);
	return r ? 0L : n;
}

imeth	long	gRetreat(long n)
{
	int	r = fseek(iFP, -n, SEEK_CUR);
	return r ? 0L : n;
}

imeth	long	gSeek(long n)
{
	int	r = fseek(iFP, n, SEEK_SET);
	return r ? 0L : n;
}

imeth	long	gPosition()
{
/*	long	ftell(FILE *);  */
	return ftell(iFP);
}

imeth	long	gLength()
{
#if	!defined(vms)  &&  !defined(__MWERKS__)
	struct	stat	sb;
	int	r;

	r = fstat(fileno(iFP), &sb);
	return r ? -1L : sb.st_size;
#else
	long	sav = ftell(iFP);
	long	len;

	fseek(iFP, 0L, SEEK_END);
	len = ftell(iFP);
	fseek(iFP, sav, SEEK_SET);
	return len;
#endif
}

imeth	char	*gName()
{
	return gStringValue(iName);
}

imeth	int	gEndOfStream()
{
	return feof(iFP);
}

imeth	void	*gPointerValue()
{
	return (void *) iFP;
}

static	void	class_init(void)
{
	String;  /*  must be initialized!  */
	stdoutStream_o = StreamObject(CLASS, "stdout", stdout);
	stderrStream_o = StreamObject(CLASS, "stderr", stderr);
	stdinStream_o  = StreamObject(CLASS, "stdin", stdin);
	traceStream_o  = stdoutStream_o;
}




/*
 *
 *	Copyright (c) 1993-1996 Algorithms Corporation
 *	3020 Liberty Hills Drive
 *	Franklin, TN  37067
 *
 *	ALL RIGHTS RESERVED.
 *
 *
 *
 */

