

/*  Copyright (c) 1993-1996 Algorithms Corporation  */
/*  All rights reserved.  */




/*  This file automatically generated by dpp - do not edit  */

#define	DPP_STRATEGY	2
#define	DPP_FASTWIDE	0




#define	CLASS	BTree_c
#define	ivType	BTree_iv_t

#include "generics.h"

object	BTree_c;


#line 26 "btree.c"
typedef struct  _BTree_iv_t  {
	object iNodes;
	long iNum;
	ifun iCmpFun;
	CRITICALSECTION iCS;
}	BTree_iv_t;



#line 26 "btree.d"
imeth ofun BTree_im_gSetFunction(object self, int (*fun)())
{ BTree_iv_t *iv = GetIVs(BTree, self);
	ofun old = (ofun) iv->iCmpFun; 
	iv->iCmpFun = fun; 
	return old; 
} 

cmeth objrtn BTree_cm_gNew(object self)
{ 
	object obj = oSuper(BTree_c, gNew, self)(self); 
	accessIVsOf(obj); 
	INITIALIZECRITICALSECTION(iv->iCS); 
	return obj; 
} 

imeth objrtn BTree_im_gDeepDispose(object self)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	ENTERCRITICALSECTION(iv->iCS); 
	if (iv->iNodes) 
		gDeepDispose(iv->iNodes); 
	LEAVECRITICALSECTION(iv->iCS); 
	DELETECRITICALSECTION(iv->iCS); 
	return oSuper(BTree_c, gDispose, self)(self); 
} 

imeth objrtn BTree_im_gDispose(object self)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	ENTERCRITICALSECTION(iv->iCS); 
	if (iv->iNodes) 
		gDispose(iv->iNodes); 
	LEAVECRITICALSECTION(iv->iCS); 
	DELETECRITICALSECTION(iv->iCS); 
	return oSuper(BTree_c, gDispose, self)(self); 
} 

imeth objrtn BTree_im_gDeepDisposeAllNodes(object self)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	ENTERCRITICALSECTION(iv->iCS); 
	if (iv->iNodes) 
		iv->iNodes = gDeepDispose(iv->iNodes); 
	iv->iNum = 0; 
	LEAVECRITICALSECTION(iv->iCS); 
	return self; 
} 

imeth objrtn BTree_im_gDisposeAllNodes(object self)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	ENTERCRITICALSECTION(iv->iCS); 
	if (iv->iNodes) 
		iv->iNodes = gDispose(iv->iNodes); 
	iv->iNum = 0; 
	LEAVECRITICALSECTION(iv->iCS); 
	return self; 
} 

imeth int BTree_im_gSize(object self)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	return iv->iNum; 
} 

imeth objrtn BTree_im_gSetTopNode(object self, object new)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	iv->iNodes = new; 
	return self; 
} 

imeth objrtn BTree_im_gAddValue(object self, object key, object val)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	object old=NULL; 
	int replaced; 

	ENTERCRITICALSECTION(iv->iCS); 
	if (!iv->iNodes) { 
		if (!iv->iCmpFun) 
			iv->iCmpFun = gCompare; 
		iv->iNodes = gNewNode(BTreeNode, self, 2); 
	} 
	gAddBTreeNode(iv->iNodes, iv->iCmpFun, key, val, 1, &replaced, NULL, &old); 
	if (replaced == 1) 
		iv->iNum++; 
	LEAVECRITICALSECTION(iv->iCS); 
	return old; 
} 

imeth objrtn BTree_im_gFindEQ(object self, object key, object *foundKey)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	object r; 
	ENTERCRITICALSECTION(iv->iCS); 
	r = iv->iNodes && iv->iNum ? gFindBTNEQ(iv->iNodes, iv->iCmpFun, key, foundKey) : NULLOBJ; 
	LEAVECRITICALSECTION(iv->iCS); 
	return r; 
} 

imeth objrtn BTree_im_gFindGE(object self, object key, object *foundKey)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	object r; 
	ENTERCRITICALSECTION(iv->iCS); 
	r = iv->iNodes && iv->iNum ? gFindBTNGE(iv->iNodes, iv->iCmpFun, key, foundKey) : NULLOBJ; 
	LEAVECRITICALSECTION(iv->iCS); 
	return r; 
} 

imeth objrtn BTree_im_gFindGT(object self, object key, object *foundKey)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	object r; 
	ENTERCRITICALSECTION(iv->iCS); 
	r = iv->iNodes && iv->iNum ? gFindBTNGT(iv->iNodes, iv->iCmpFun, key, foundKey) : NULLOBJ; 
	LEAVECRITICALSECTION(iv->iCS); 
	return r; 
} 

imeth objrtn BTree_im_gFindNext(object self, object *foundKey)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	object r; 
	ENTERCRITICALSECTION(iv->iCS); 
	if (*foundKey) { 
		object key = *foundKey; 
		r = gFindBTNGT(iv->iNodes, iv->iCmpFun, key, foundKey); 
	} else 
		r = gFindFirst(self, foundKey); 
	LEAVECRITICALSECTION(iv->iCS); 
	return r; 
} 

imeth objrtn BTree_im_gFindLE(object self, object key, object *foundKey)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	object r; 
	ENTERCRITICALSECTION(iv->iCS); 
	r = iv->iNodes && iv->iNum ? gFindBTNLE(iv->iNodes, iv->iCmpFun, key, foundKey) : NULLOBJ; 
	LEAVECRITICALSECTION(iv->iCS); 
	return r; 
} 

imeth objrtn BTree_im_gFindLT(object self, object key, object *foundKey)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	object r; 
	ENTERCRITICALSECTION(iv->iCS); 
	r = iv->iNodes && iv->iNum ? gFindBTNLT(iv->iNodes, iv->iCmpFun, key, foundKey) : NULLOBJ; 
	LEAVECRITICALSECTION(iv->iCS); 
	return r; 
} 

imeth objrtn BTree_im_gFindPrev(object self, object *foundKey)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	object r; 
	ENTERCRITICALSECTION(iv->iCS); 
	if (*foundKey) { 
		object key = *foundKey; 
		r = gFindBTNLT(iv->iNodes, iv->iCmpFun, key, foundKey); 
	} else 
		r = gFindLast(self, foundKey); 
	LEAVECRITICALSECTION(iv->iCS); 
	return r; 
} 

imeth objrtn BTree_im_gFindFirst(object self, object *foundKey)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	object r; 
	ENTERCRITICALSECTION(iv->iCS); 
	r = iv->iNodes && iv->iNum ? gFindBTNFirst(iv->iNodes, iv->iCmpFun, foundKey) : NULLOBJ; 
	LEAVECRITICALSECTION(iv->iCS); 
	return r; 
} 

imeth objrtn BTree_im_gFindLast(object self, object *foundKey)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	object r; 
	ENTERCRITICALSECTION(iv->iCS); 
	r = iv->iNodes && iv->iNum ? gFindBTNLast(iv->iNodes, iv->iCmpFun, foundKey) : NULLOBJ; 
	LEAVECRITICALSECTION(iv->iCS); 
	return r; 
} 

imeth objrtn BTree_im_gDisposeObj(object self, object key)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	object res; 
	ENTERCRITICALSECTION(iv->iCS); 
	res = iv->iNodes && iv->iNum ? gDeleteBTNode(iv->iNodes, iv->iCmpFun, key, 0, NULL) : NULL; 
	if (res) 
		iv->iNum--; 
	LEAVECRITICALSECTION(iv->iCS); 
	return res; 
} 

imeth objrtn BTree_im_gDeepDisposeObj(object self, object key)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	object res; 
	ENTERCRITICALSECTION(iv->iCS); 
	res = iv->iNodes && iv->iNum ? gDeleteBTNode(iv->iNodes, iv->iCmpFun, key, 1, NULL) : NULL; 
	if (res) 
		iv->iNum--; 
	LEAVECRITICALSECTION(iv->iCS); 
	return res; 
} 

imeth objrtn BTree_im_gPrint(object self, object stream)
{ BTree_iv_t *iv = GetIVs(BTree, self);
	ENTERCRITICALSECTION(iv->iCS); 
	vPrintf(stream, "BTree [%8.8lx], %ld keys, first node is %8.8lx\n", self, iv->iNum, iv->iNodes); 
	if (iv->iNodes) { 
		gPuts(stream, "\n------------------------------------------------------------\n"); 
		gPrint(iv->iNodes, stream); 
	} 
	LEAVECRITICALSECTION(iv->iCS); 
	return self; 
} 


#line 245 "btree.c"

objrtn	BTree_initialize(void)
{
	static  CRITICALSECTION  cs;
	static  int volatile once = 0;

	ENTERCRITICALSECTION(_CI_CS_);
	if (!once) {
		INITIALIZECRITICALSECTION(cs);
		once = 1;
	}
	LEAVECRITICALSECTION(_CI_CS_);

	ENTERCRITICALSECTION(cs);

	if (BTree_c) {
		LEAVECRITICALSECTION(cs);
		return BTree_c;
	}
	INHIBIT_THREADER;
	BTree_c = gNewClass(Class, "BTree", sizeof(BTree_iv_t), 0, END);
	cMethodFor(BTree, gNew, BTree_cm_gNew);
	iMethodFor(BTree, gDeepDisposeObj, BTree_im_gDeepDisposeObj);
	iMethodFor(BTree, gSetFunction, BTree_im_gSetFunction);
	iMethodFor(BTree, gFindGE, BTree_im_gFindGE);
	iMethodFor(BTree, gFindLT, BTree_im_gFindLT);
	iMethodFor(BTree, gFindPrev, BTree_im_gFindPrev);
	iMethodFor(BTree, gDisposeObj, BTree_im_gDisposeObj);
	iMethodFor(BTree, gPrint, BTree_im_gPrint);
	iMethodFor(BTree, gDisposeAllNodes, BTree_im_gDisposeAllNodes);
	iMethodFor(BTree, gFindLast, BTree_im_gFindLast);
	iMethodFor(BTree, gSize, BTree_im_gSize);
	iMethodFor(BTree, gDeepDisposeAllNodes, BTree_im_gDeepDisposeAllNodes);
	iMethodFor(BTree, gFindGT, BTree_im_gFindGT);
	iMethodFor(BTree, gDispose, BTree_im_gDispose);
	iMethodFor(BTree, gFindFirst, BTree_im_gFindFirst);
	iMethodFor(BTree, gFindLE, BTree_im_gFindLE);
	iMethodFor(BTree, gFindEQ, BTree_im_gFindEQ);
	iMethodFor(BTree, gSetTopNode, BTree_im_gSetTopNode);
	iMethodFor(BTree, gAddValue, BTree_im_gAddValue);
	iMethodFor(BTree, gDeepDispose, BTree_im_gDeepDispose);
	iMethodFor(BTree, gFindNext, BTree_im_gFindNext);

	ENABLE_THREADER;

	LEAVECRITICALSECTION(cs);

	return BTree_c;
}



