import java.applet.*;
import java.awt.*;
import java.util.*;
import LittleWalkFrame;
import ProcessEntry32;
import ToolHelp;

public class LittleWalk extends Applet implements Runnable
{
	Thread	 m_LittleWalk = null;
	ToolHelp th;
	List ProcList;

	// STANDALONE APPLICATION SUPPORT:
	//		m_fStandAlone will be set to true if applet is run standalone
	//--------------------------------------------------------------------------
	boolean m_fStandAlone = false;

	public static void main(String args[])
	{
		
		Frame frame = new Frame("LittleWalk");

		// Must show Frame before we size it so insets() will return valid values
		//----------------------------------------------------------------------
		frame.show();
        frame.hide();
		frame.resize(frame.insets().left + frame.insets().right  + 320,
					 frame.insets().top  + frame.insets().bottom + 240);

		LittleWalk applet_LittleWalk = new LittleWalk();

		frame.add("Center", applet_LittleWalk);
		applet_LittleWalk.m_fStandAlone = true;
		applet_LittleWalk.init();
		applet_LittleWalk.start();
        frame.show();
	}

	public LittleWalk()
	{
	}

	public String getAppletInfo()
	{
		return "Name: LittleWalk\r\n" +
		       "Author: Andy Wilson\r\n" +
		       "Created with Microsoft Visual J++ Version 1.0";
	}


	public void init()
	{
        
		// If you use a ResourceWizard-generated "control creator" class to
        // arrange controls in your applet, you may want to call its
        // CreateControls() method from within this method. Remove the following
        // call to resize() before adding the call to CreateControls();
        // CreateControls() does its own resizing.
        //----------------------------------------------------------------------

		resize(320, 240);
		
		setLayout(new BorderLayout());
		add("North", ProcList = new List());

	}

	public void destroy()
	{
	}

	public void paint(Graphics g)
	{
		g.drawString("Running: " + Math.random(), 10, 20);
	}

	public void start()
	{
		if (m_LittleWalk == null)
		{
			m_LittleWalk = new Thread(this);
			m_LittleWalk.start();
		}
	}
	
	public void stop()
	{
		if (m_LittleWalk != null)
		{
			m_LittleWalk.stop();
			m_LittleWalk = null;
		}
	}

	public void run()
	{
		th = new ToolHelp();
		Vector foo = th.getProcList();

		ProcessEntry32 temp = null;
		while(foo.size () > 0)
		{
			try
			{
				temp = (ProcessEntry32) foo.firstElement();
				ProcList.addItem("PE32="+temp.szExeFile+" "+temp.cntThreads);
				foo.removeElement( temp);
			} catch (NoSuchElementException ne)
			{
				System.out.println(ne.getMessage());
			}
		}
		while (true)
		{
			try
			{
				repaint();
				Thread.sleep(50);
			}
			catch (InterruptedException e)
			{
				stop();
			}
		}
	}


}
