/*
** EXAMP085.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dblib.h"

int iDBF, iMDX, iPercent=50;
long lRecNo, lTag;
char szKey[13];

DBFIELD aField[] = { { "FILENAME", 'C', 12, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "FILENAME", DBCHARACTERKEY, "FILENAME", 12, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   DBPutFieldData( iDBF, 0, "CONFIG.SYS" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBInsertKey( lTag, "CONFIG.SYS", lRecNo );
   DBPutFieldData( iDBF, 0, "AUTOEXEC.BAT" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBInsertKey( lTag, "AUTOEXEC.BAT", lRecNo );
   DBPutFieldData( iDBF, 0, "COMMAND.COM" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBInsertKey( lTag, "COMMAND.COM", lRecNo );
   DBGoFirstKey( lTag, szKey, &lRecNo );
   while( DBGetErrorCode() == DBSUCCESS )
   {
      printf( "%ld %s\n", lRecNo, szKey );
      DBGoNextKey( lTag, szKey, &lRecNo );
   }
   strcpy( szKey, "COMMAND.COM" );
   lRecNo=3L;
   DBGetKeyPercent( lTag, &iPercent, szKey, lRecNo );
   printf( "\nKey COMMAND.COM is at %d percent", iPercent );
   DBCloseIndex( iMDX );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
