/*
** EXAMP041.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd..  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF;
long lRecNo;
char szBuffer[21];
double dValue;

DBFIELD aField[] = {
   { "branch", DBNUMERICFIELD, 3, 0 },
   { "salesman", DBCHARACTERFIELD, 20, 0 },
   { "quota", DBNUMERICFIELD, 9, 2 }
};

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "salesmen.dbf", sizeof(aField)/sizeof(DBFIELD), aField, DBCLIPPER5 );
   DBOpenFile( &iDBF, "salesmen.dbf", DBCLIPPER5 );
   dValue = 100;
   DBPutNamedData( iDBF, "branch", &dValue);
   DBPutNamedData( iDBF, "salesman", "Ralph Schwartz" );
   dValue = 150000.0l;
   DBPutNamedData( iDBF, "quota", &dValue );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   dValue = 100;
   DBPutNamedData( iDBF, "branch", &dValue);
   DBPutNamedData( iDBF, "salesman", "Bobby Hinze" );
   dValue = 125000.0l;
   DBPutNamedData( iDBF, "quota", &dValue );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   dValue = 300;
   DBPutNamedData( iDBF, "branch", &dValue);
   DBPutNamedData( iDBF, "salesman", "Marsha Clark" );
   dValue = 200000l;
   DBPutNamedData( iDBF, "quota", &dValue );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   dValue = 500;
   DBPutNamedData( iDBF, "branch", &dValue);
   DBPutNamedData( iDBF, "salesman", "Eric Nelson" );
   dValue = 125000l;
   DBPutNamedData( iDBF, "quota", &dValue );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   dValue = 400;
   DBPutNamedData( iDBF, "branch", &dValue);
   DBPutNamedData( iDBF, "salesman", "Joe Wipper" );
   dValue = 150000l;
   DBPutNamedData( iDBF, "quota", &dValue );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   dValue = 200;
   DBPutNamedData( iDBF, "branch", &dValue);
   DBPutNamedData( iDBF, "salesman", "Jean Larson" );
   dValue = 150000l;
   DBPutNamedData( iDBF, "quota", &dValue );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

   DBSetFilter( iDBF, "quota >= 149000" );
   lRecNo = 1l;
   do
   {
      DBGetRecord( iDBF, lRecNo );
      if (DBFilterRecord( iDBF ))
      {
         DBGetNamedStr( iDBF, "salesman", szBuffer );
         printf( "%s\n", szBuffer );
      }
      lRecNo++;
   } while (!DBIsEndOfFile( iDBF ));
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
