/*
** L1DEM021.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

DBFIELD Fields[] = { { "VERDICT", 'L',  1, 0 },
                     { "NAME",    'C', 10, 0 } };

int  iDBF, iCDX, iVerdict, iStatus;
long lRecNo, lTag;
char szKey[2], szName[11], szVerdict[2];

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 2, Fields, DBFOXPRO2|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBFOXPRO2 );

   DBCreateIndex( "EXAMPLE.CDX", 1, DBFOXPRO2|DBPRODUCTIONINDEX|DBCOMPOUNDINDEX|DBCOMPRESSEDINDEX );
   DBOpenIndex( &iCDX, "EXAMPLE.CDX", DBOPENSTANDARD|DBFOXPRO2 );

   DBPutFieldData( iDBF, 0, "T");
   DBPutFieldData( iDBF, 1, "Marc");
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBPutFieldData( iDBF, 0, "F");
   DBPutFieldData( iDBF, 1, "John");
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBPutFieldData( iDBF, 0, "T");
   DBPutFieldData( iDBF, 1, "Tom");
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBPutFieldData( iDBF, 0, "F");
   DBPutFieldData( iDBF, 1, "Amie");
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBPutFieldData( iDBF, 0, "T");
   DBPutFieldData( iDBF, 1, "Ashley");
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

   DBBuildTag( iDBF, iCDX, "VERDICT", DBLOGICALKEY, "VERDICT", 1, 0, NULL, NULL, 0 );

   DBOpenNamedTag( &lTag, iCDX, "VERDICT" );
   DBSetDefaultKeyType( lTag, DBLOGICALKEY );

   DBGoFirstKey( lTag, szKey, &lRecNo );

   while( iStatus == DBSUCCESS )
   {
      DBGetRecord( iDBF, lRecNo );
      DBGetFieldData( iDBF, 0, &iVerdict );
      DBGetFieldData( iDBF, 1, szName );
      printf( "Record#: %ld Name: %s Verdict: %d\n", lRecNo, szName, iVerdict );
      iStatus = DBGoNextKey( lTag, szKey, &lRecNo );
   }

   DBCloseIndex( iCDX );
   DBCloseFile( iDBF );
   DBTerminate();
}
