/*
** L1DEM018.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

long lTag, lRecNo;
int iLoop, iDBF, iCDX, iStatus;
char szKey[3], szLetter[4];
char *pAlphabet[] = { "AA","BB", "CC" };

/* Always use a DUMMY field with DBREUSEDELETED 5 characters in length! */
DBFIELD Field[] = { { "DUMMY",  'C', 5, 0 },
                    { "LETTER", 'C', 3, 0 } };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 2, Field, DBFOXPRO2|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBFOXPRO2|DBREUSEDELETED );

   DBCreateIndex( "EXAMPLE.CDX", 1, DBFOXPRO2|DBPRODUCTIONINDEX|DBCOMPOUNDINDEX|DBCOMPRESSEDINDEX );
   DBOpenIndex( &iCDX, "EXAMPLE.CDX", DBFOXPRO2 );

   DBCreateTag( iCDX, "LETTER", DBCHARACTERKEY, "LETTER", 2, 0, NULL );
   DBOpenTag( &lTag, iCDX, 1 );
   DBSetDefaultKeyType( lTag, DBCHARACTERKEY );

   for( iLoop = 0; iLoop < 3; iLoop++ )
   {
      DBPutFieldData( iDBF, 1, pAlphabet[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
      printf( "%ld %s\n", lRecNo, pAlphabet[ iLoop ] );

      DBInsertKey( lTag, pAlphabet[ iLoop ], lRecNo );
   }

   puts( "" );

   strcpy( szKey, "BB" );
   DBKeySearch( lTag, szKey, &lRecNo, DBKEYEQUAL );

   DBMarkRecordInActive( iDBF, lRecNo );
   DBDeleteKey( lTag, szKey, lRecNo );

   DBPutFieldData( iDBF, 1, "ZZ" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

   DBInsertKey( lTag, "ZZ", lRecNo );

   DBGoFirstKey( lTag, szKey, &lRecNo );

/* Display records.  Notice that record 2 was reused. */
   while( iStatus == DBSUCCESS )
   {
      DBGetRecord( iDBF, lRecNo );
      DBGetFieldData( iDBF, 1, szLetter );
      printf( "%ld %s\n", lRecNo, szLetter );
      iStatus = DBGoNextKey( lTag, szKey, &lRecNo );
   }

   DBCloseFile( iDBF );
   DBCloseIndex( iCDX );
   DBTerminate();
}
