/*
 *  EXAMP021.C
 *
 *  The SoftC Database Library
 *
 *  COPYRIGHT (C) 1994, 1997 SoftC, Ltd. ALL RIGHTS RESERVED.
 *
 */

#include <stdio.h>

#include "dblib.h"

int iDBF;
long lRecNo;
char szFileName[81];
double dValue;
DBFIELD fields[] = {
   { "filename", 'c', 12, 0 },
   { "length", 'n', 9, 0 },
   { "date", 'd', 8, 0 }
};

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "toc.dbf", sizeof(fields)/sizeof(DBFIELD), fields, DBCLIPPER5);
   if ( DBOpenFile( &iDBF, "toc.dbf", DBCLIPPER5 ) == DBSUCCESS )
   {
      DBPutNamedData( iDBF, "filename", "autoexec.bat");
      dValue = 235;
      DBPutNamedData( iDBF, "length", &dValue );
      DBPutNamedData( iDBF, "date", "11/15/96" );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD);
      DBPutNamedData( iDBF, "filename", "config.sys");
      dValue = 107;
      DBPutNamedData( iDBF, "length", &dValue );
      DBPutNamedData( iDBF, "date", "10/31/96" );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD);
      DBPutNamedData( iDBF, "filename", "command.com");
      dValue = 27835;
      DBPutNamedData( iDBF, "length", &dValue );
      DBPutNamedData( iDBF, "date", "05/19/95" );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD);
      DBPutNamedData( iDBF, "filename", "autoexec.bak");
      dValue = 261;
      DBPutNamedData( iDBF, "length", &dValue );
      DBPutNamedData( iDBF, "date", "11/14/96" );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD);
      DBPutNamedData( iDBF, "filename", "config.bak");
      dValue = 190;
      DBPutNamedData( iDBF, "length", &dValue );
      DBPutNamedData( iDBF, "date", "10/27/96" );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD);

      printf( "ascending order:\n" );
      lRecNo = 1l;
      do
      {
         DBGetRecord( iDBF, lRecNo );
         DBGetFieldData( iDBF, 0, szFileName );
         printf( "%s\n", szFileName );
         lRecNo += 1l;
      } while ( !DBIsEndOfFile( iDBF ) );

      printf( "descending order:\n");
      lRecNo = 5l;
      do
      {
         DBGetRecord( iDBF, lRecNo );
         DBGetFieldData( iDBF, 0, szFileName );
         printf( "%s\n", szFileName );
         lRecNo--;
      } while ( !DBIsBeginningOfFile( iDBF ) );
      DBCloseFile( iDBF );
   }
   DBTerminate();
}
