/*
** L1DEM022.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

DBFIELD Fields[] = { { "NAME", 'C', 10, 0 },
                     { "AGE",  'N',  2, 0 } };

int iDBF, iCDX, iLoop;
long lTag, lRecNo;
char szKey[13], *pKey;
char *pNames[] = { "Marc", "Billy", "Tom", "Lucy", "Marc" };
double dAges[5] = { 25, 34, 33, 43, 29 };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 2, Fields, DBFOXPRO2|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBFOXPRO2 );

   DBCreateIndex( "EXAMPLE.CDX", 1, DBFOXPRO2|DBPRODUCTIONINDEX|DBCOMPOUNDINDEX|DBCOMPRESSEDINDEX );
   DBOpenIndex( &iCDX, "EXAMPLE.CDX", DBFOXPRO2 );

   DBCreateTag( iCDX, "AGENAME", DBCHARACTERKEY, "STR(AGE,2,0)+NAME", 12, 0, NULL );

   DBOpenNamedTag( &lTag, iCDX, "AGENAME" );
   DBSetDefaultKeyType( lTag, DBCHARACTERKEY );

   for( iLoop = 0; iLoop < 5; iLoop++ )
   {
      printf( "Name and age added: %-10s %2.0f\n", pNames[ iLoop ], dAges[ iLoop ] );

      DBPutFieldData( iDBF, 0, pNames[ iLoop ] );
      DBPutFieldData( iDBF, 1, &dAges[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

      DBMakeKey( iDBF, lTag, ( void ** )&pKey );
      DBInsertKey( lTag, pKey, lRecNo );
      DBFreeMemory( pKey );
   }

   puts( "" );

   DBGoFirstKey( lTag, szKey, &lRecNo );

   while( DBGetErrorCode() == DBSUCCESS )
   {
      printf( "Key is %s\n", szKey );
      DBGoNextKey( lTag, szKey, &lRecNo );
   }

   DBCloseIndex( iCDX );
   DBCloseFile( iDBF );
   DBTerminate();
}
