/*
** L1DEM001.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

DBFIELD Fields[] = { { "FNAME", 'C', 20, 0 },
                     { "LNAME", 'C', 20, 0 } };

int iDBF, iLoop, iNTX;
long lRecNo, lNTX;
char szKey[41], *pKey;
char *pFNames[] = { "Marc", "Billy", "Tom", "Lucy", "Ruby" };
char *pLNames[] = { "Leger", "McDaniel", "Adams", "Adams", "Crawford" };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 2, Fields, DBCLIPPER5 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBCLIPPER5 );

   DBCreateIndex( "EXAMPLE.NTX", 1, DBCLIPPER5);
   DBOpenIndex( &iNTX, "EXAMPLE.NTX", DBOPENSTANDARD|DBCLIPPER5 );
   DBCreateTag( iNTX, "EXAMPLE", DBUNIQUEINDEX|DBCHARACTERKEY, "LNAME+FNAME", 40, 0, NULL );
   DBOpenTag( &lNTX, iNTX, DBCLIPPER5);

   for( iLoop = 0; iLoop < 5; iLoop++ )
   {
      DBPutFieldData( iDBF, 0, pFNames[ iLoop ] );
      DBPutFieldData( iDBF, 1, pLNames[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

      DBMakeKey( iDBF, lNTX, ( void ** )&pKey );
      DBInsertKey( lNTX, pKey, lRecNo );
      DBFreeMemory( pKey );
   }

   DBGoFirstKey( lNTX, szKey, &lRecNo );

   while( DBGetErrorCode() == DBSUCCESS )
   {
      printf( "Key stored: %ld %s\n", lRecNo, szKey );
      DBGoNextKey( lNTX, szKey, &lRecNo );
   }

   sprintf( szKey, "%-20s%-20s", "Leger", "Marc" );
   DBKeySearch( lNTX, szKey, &lRecNo, DBKEYEQUAL );
   printf( "\nKey found : %ld %s\n", lRecNo, szKey );

   DBCloseIndex( iNTX );
   DBCloseFile( iDBF );
   DBTerminate();
}
