[Caption: Listing 1 -- <f>CommsChannel<d> Definition]

#if !defined(commsChannel_HPP_ONCEONLY)
#define commsChannel_HPP_ONCEONLY

#include <windows.h>
#include <string>
using namespace std;

struct CommsData;             // forward definition

#if defined(__DLL__)
__declspec(dllexport)
#else
__declspec(dllimport)
#endif
class CommsChannel {
public:

   enum statusEnum {
      ok = 0,                    //first ones are >= 0
      waitError,
      waitTimeout,
      waitTimeoutChunkTooSmall,
      objectAlreadyOpen = -1000, //All of the rest are < 0
      objectClosed,
      mutexCreationError,
      mutexOpenError,
      mutexAlreadyExists,
      mutexNotFound,
      channelCreationError,
      channelOpenError,
      channelMappingError,
      channelAlreadyExists,
      channelNotFound
      };

   CommsChannel(string name, int size);
   CommsChannel(string name);
   CommsChannel();
   ~CommsChannel();

   statusEnum open(string name, int size);
   statusEnum open(string name);
   statusEnum close();

   int read(char* buffer, int size,
            bool chunk = false, DWORD timeOut = 0);
   int write(char* buffer, int size,
             bool chunk = true, DWORD timeOut = 0);

   int readImmediate(char* buffer, int size, bool chunk = false)
          {read(buffer, size, chunk, 0);}
   int writeImmediate(char* buffer, int size, bool chunk = true)
          {write(buffer, size, chunk, 0);}

   int readBlocking(char* buffer, int size, bool chunk = false)
          {read(buffer, size, chunk, INFINITE);}
   int writeBlocking(char* buffer, int size, bool chunk = true)
          {write(buffer, size, chunk, INFINITE);}

   statusEnum status() const {return error;}
   const string& name() const;

   int   bytesToRead() const;
   int   roomToWrite() const;

private:
   bool              opened;
   string            channelName;
   bool              server;
   char*             fsBuffer;
   char*             tsBuffer;

   statusEnum        error;

   HANDLE            handle;
   HANDLE            generalMutex;
   HANDLE            fsNotEmptySem;
   HANDLE            fsNotFullSem;
   HANDLE            tsNotEmptySem;
   HANDLE            tsNotFullSem;
   CommsData*        data;

   static string     noName;

   int blockOnChannel(int size, bool chunk, DWORD timeout,
                      bool reading, HANDLE& mutex, HANDLE& semaphore,
                      int& start, int& next);

};

#endif // !defined(commsChannel_HPP_ONCEONLY)


