
[Caption: Listing 2 -- Implementation of <f>Company<d> using reference
count template]

#include <stdio.h>
#include <string.h>
#include <memory.h>
#include "refcount.h"

///////////////////////////////////////////////////////////////////
// Data structure for storing variables for class Company
struct SCompany
{
    SCompany()
    {
        memset(m_szCompanyName, 0, sizeof(m_szCompanyName));
        memset(m_szAddress, 0, sizeof(m_szAddress));
    }

    SCompany(const SCompany& struCompany)
    {
        strcpy(m_szCompanyName, struCompany.m_szCompanyName);
        strcpy(m_szAddress, struCompany.m_szAddress);
    }

    char m_szCompanyName[81];
    char m_szAddress[128];
};

class Company : public CHReferenceCount<SCompany>
{
public:
    // Data accessing functions - using const GetData()
    const char* GetCompanyName() const
        { return GetData()->m_szCompanyName; }

    const char* GetAddress() const
        { return GetData()->m_szAddress; }

    // Data manipulation functions - using non-const GetData()
    void SetCompanyName(const char* szCompanyName)
        { strcpy(GetData()->m_szCompanyName, szCompanyName);}

    void SetAddress(const char* szAddress)
        { strcpy(GetData()->m_szAddress, szAddress);}
};


int main()
{
    Company objCompany;
    objCompany.SetCompanyName("ABC Company");
    objCompany.SetAddress("100 Main Street, Nowhereville USA");

    printf("Company name: %s\n",objCompany.GetCompanyName());
    printf("Address     : %s\n",objCompany.GetAddress());

    return 0;
}
