[Caption: Listing 3 -- A logging example using <f>CommChannel<d>]

#include <iostream.h>
#include "channel.hpp"
#include <string.h>

#define LOG_BUFFER   255

class LogServer {
   public:
      LogServer();
      void run();

   private:
      CommsChannel   server;
      bool           ok;
   };

class Logger {
   public:
      Logger();
      void log(string message);

   private:
      CommsChannel   client;
      bool           ok;
   };


// Log server implementation

LogServer::LogServer () : server("ExampleLogger", LOG_BUFFER) {
   if ( server.status() == CommsChannel::ok ) {
      ok = true;
      }
   else {
      ok = false;
      cout << "CommsChannel could not be opened." << endl;
      }
   }

void
LogServer::run() {
   char buffer[LOG_BUFFER+1];
   int bytes;
   char pause;

   cout << "Log server started" << endl;

   while (ok) {
      bytes = server.readBlocking(buffer, 1);
      if (bytes == 1) {
         bytes = buffer[0];
         bytes = server.readBlocking(buffer, bytes);
         if (bytes > 0) {
            buffer[bytes] = '\0';
            cout << buffer << endl;
            }

         cin >> pause;
         }

      if (server.status() != CommsChannel::ok) {
         ok = false;
         }
      }

   cout << "Log server stopping. Last status was: ";
   cout << server.status() << endl;
   }

// Log client implementation

Logger::Logger () : client("ExampleLogger") {
   if ( client.status() == CommsChannel::ok ) {
      ok = true;
      }
   else {
      ok = false;
      cout << "CommsChannel could not be opened." << endl;
      }
   }

void
Logger::log(string word) {
   char buffer[LOG_BUFFER+1];
   int bytes = word.length();

   if (bytes-2 > LOG_BUFFER) {
      cout << "Error while logging. Data too long" << endl;
      }

   buffer[0] = bytes;
   strcpy(&buffer[1], word.c_str());

   if (client.writeBlocking(buffer, bytes+2) < 0) {
      cout << "Error while logging. Last status was: ";
      cout << client.status() << endl;
      }
   }

// Testing - run with an argument in one process for a server,
// without an argument in another process as the client
void main(int argc) {
   if (argc > 1) {      // server
      LogServer s;
      s.run();
      }
   else {               // client
      string word;
      Logger l;
      while(true) {
         cout << "Log word: ";
         cin >> word;
         l.log(word);
         }
      }
   }

