[Caption: Listing 3 -- Example of how to implement and use SG functions
with a processor architecture which only have a single linear address
space]

// Defined in iohw.h
#define access8 volatile unsigned char *
#define iowr8( PADDR, PVAL ) (* ( PADDR ) = ( PVAL ))
#define iowrbuf8( PADDR, PINDEX, PVAL ) \
   (( PADDR )[( PINDEX )] = ( PVAL ))
#include <iohw_ta.h>

// Defined in iohw_ta.h
#define PORT1 ((access8) (0xfff0)) // I/O register definition

// Portable driver function module
#include <iohw.h>

void nibblewr1 ( unsigned char data ) 
   {
   iowr8( PORT1, data & 0xf);
   iowr8( PORT1, data >> 4);
   }

void nibblewr2 ( access8 adr, unsigned char data ) 
   {
   iowr8( adr, data & 0xf);
   iowr8( adr, data >> 4);
   }

void nibblewr3 ( unsigned int index, unsigned char data ) 
   {
   iowrbuf8( PORT1, index, data & 0xf);
   iowrbuf8( PORT1, index, data >> 4);
   }

void nibblewr4 ( access8 adr, unsigned int index, 
                 unsigned char data )
   {
   iowrbuf8( adr, index, data & 0xf);
   iowrbuf8( adr, index, data >> 4);
   }

void iotest(void)
   {
   nibblewr1( 0x12 );
   nibblewr2( PORT1, 0x34 );
   nibblewr3( 10, 0x56);
   nibblewr4( PORT1, 3, 0x78 );
   }

