[Caption: Listing 5 -- CPU family 80x86, Compiler Borland C/C++.
Compiler dependent definements in iohw.h]

#define access8 volatile unsigned char *

#define iowr8( PID, PVAL ) ( WR##PID ( PVAL )))
#define iord8( PID ) (( RD##PID ))

// Physical address to 80x86 memory pointer conversion
#define MEMADR( laddr ) (\
     ((unsigned long) ((laddr##UL) >> 16L) << 28L) | \
     ((unsigned long) ((laddr##UL) % 0x10000L)))


//** Definement of I/O registers in iohw_ta.h  
// Memory mapped address space 
#define PORT1 ((access8) MEMADR(0xffff0))
#define WRPORT1 PORT = (
#define RDPORT1 PORT1

// I/O mapped address space 
#define PORT2  0xE082
#define WRPORT2  outportb(PORT2,
#define RDPORT2  inportb( PORT2 )

//** Driver module
include <iohw.h>

void my_func(char val)
   {
   if (iord8(PORT2) & 0x40)
      iowr8(PORT1,val);
   else
      iowr8(PORT1, (iord8(PORT1) & 0xf) | val);
   }
