///////////////////////////////////////////////////////////////////////////
// Copyright (c) Panos Kougiouris 1997
///////////////////////////////////////////////////////////////////////////

#include <kfReferenceCount.h>

CKFReferenceCount::CKFReferenceCount()
{
    m_count = 1;
}

CKFReferenceCount::~CKFReferenceCount()
{
    assert(m_count == 0);
}

//--------------------------------------------------------

void 
CKFReferenceCount::increment()
{
    InterlockedIncrement((LPLONG)&m_count);
}

//--------------------------------------------------------

void 
CKFReferenceCount::decrement()
{
    LONG ret = InterlockedDecrement((LPLONG)&m_count);
    assert(ret >= 0);  // less than 0 means too many decrements
    if (m_count == 0) {
        delete this;
    }
}

//--------------------------------------------------------

int 
CKFReferenceCount::count()
{
    return m_count;   
}

//--------------------------------------------------------

