///////////////////////////////////////////////////////////////////////////
// Copyright (c) Panos Kougiouris 1997
///////////////////////////////////////////////////////////////////////////

#ifndef __CKFMTMUTEX_WIN32_HH__
#define __CKFMTMUTEX_WIN32_HH__

class CKFMTMutexImplementation : public CKFReferenceCount {
  public:
    HANDLE          m_mutex;
    unsigned long   m_last_owner;

    
    CKFMTMutexImplementation(const char* name)
    {
        m_mutex = CreateMutex(NULL, // default security
                              FALSE, // not owned
                              name);

	m_last_owner = -1;

    }

  private:
    ~CKFMTMutexImplementation()
    {
        CloseHandle(m_mutex);
    }
};

#endif