///////////////////////////////////////////////////////////////////////////
// Copyright (c) Panos Kougiouris 1997
///////////////////////////////////////////////////////////////////////////

#ifndef __CKFREFERENCECOUNT_HH_
#define __CKFREFERENCECOUNT_HH_

#include <kfBase.h>

#ifdef POSIX_THREADS
#include <pthread.h>
#endif

// This class is intended as a superclass for classes
// that need reference counting. In an MT environment
// reference counting simplifies memory management.

class CKFEXPORT CKFReferenceCount {
  public:
    // Create a new RefernceCount with count 1
    CKFReferenceCount();

    // Increments the count in an atomic way
    void increment();

    // decrements the count in an atomic way. If the
    // count reaches 0 it calls the destructor
    void decrement();

    int count();

   protected:

     virtual ~CKFReferenceCount();

      
#ifdef WIN32
     volatile LONG m_count;
#elif defined(POSIX_THREADS)
     pthread_mutex_t m_mutex;
     volatile int m_count;
#else
    error specify a POSIX_THREADS or WIN32
#endif
};

#endif
