////////////////////////////
// Marco Framba 1997 
////////////////////////////
#include <kfThread.h>
#include "list.h"

list::list()
{
    total = 0;
    first = NULL;
    last = NULL;
}

void
list::insert(void *resource)
{
    CKFMT::CMutexGrabber grab(mutex);

    lstElem_t *old = last;
    last = new lstElem_t;
    last->next = NULL;
    last->resource = resource;

    if (old == NULL) {
	first = last;
    } else {
	old->next = last;
    }
    total++;
    waitfor_resources.signal(); 
}

void *
list::get()
{
    CKFMT::CMutexGrabber grab(mutex);
    CKFMT::RetValue rt;

    while (first == NULL) {
	rt = waitfor_resources.wait(mutex, 3 * 1000); // wait up to 3 secs
	if (rt == CKFMT::Timeout) 
	    return NULL;
    }

    lstElem_t *old = first;
    assert(old != NULL);

    first = first->next;
    if (first == NULL)
	last = NULL;
    
    void *rv = old->resource;
    delete old;
    total--;
    return rv;
}
