///////////////////////////////////////////////////////////////////////////
// Copyright (c) Marco Framba 1997
///////////////////////////////////////////////////////////////////////////
#include <kfThread.h>
#include <kfReferenceCount.h>
#include "kfRWMutex.h" 

CKFMT::CRWMutex::CRWMutex(const char* a_name)
{
    m_impl = new CKFMTRWMutexImplementation(a_name);  
}

CKFMT::CRWMutex::CRWMutex(const CKFMT::CRWMutex& a_m)
{
    m_impl = a_m.m_impl;
    m_impl->increment();
}

CKFMT::CRWMutex& 
CKFMT::CRWMutex::operator= (const CKFMT::CRWMutex& a_m)
{ 
    m_impl->decrement();
    m_impl = a_m.m_impl;
    m_impl->increment();

    return *this;
}

CKFMT::CRWMutex::~CRWMutex()
{
    m_impl->decrement();
}

void
CKFMT::CRWMutex::rdlock()
{
    m_impl->m_mutex.lock();
    while (m_impl->m_readwritelcks < 0 || 
	   m_impl->m_wait_wrtr)
        m_impl->m_wait_readers.wait(m_impl->m_mutex);
    m_impl->m_readwritelcks++;
    m_impl->m_mutex.unlock();
}

CKFMT::RetValue
CKFMT::CRWMutex::try_rdlock()
{
    m_impl->m_mutex.lock();
    if (m_impl->m_readwritelcks < 0 || 
	m_impl->m_wait_wrtr) {
	m_impl->m_mutex.unlock();
        return AlreadyLocked;
    }
    m_impl->m_readwritelcks++;
    m_impl->m_mutex.unlock();
    return Ok;
}

void
CKFMT::CRWMutex::wrlock()
{
    m_impl->m_mutex.lock();
    while (m_impl->m_readwritelcks != 0) {
        m_impl->m_wait_wrtr++;
        m_impl->m_wait_writers.wait(m_impl->m_mutex);
        m_impl->m_wait_wrtr--;
    }
    m_impl->m_readwritelcks = -1;
    m_impl->m_mutex.unlock();
}

CKFMT::RetValue
CKFMT::CRWMutex::try_wrlock()
{
    m_impl->m_mutex.lock();
    if (m_impl->m_readwritelcks != 0) {
	m_impl->m_mutex.unlock();
	return AlreadyLocked;
    }
    m_impl->m_readwritelcks = -1;
    m_impl->m_mutex.unlock();
    return Ok;
}

void
CKFMT::CRWMutex::unlock()
{
    int waiting_writers;
    int waiting_readers;

    m_impl->m_mutex.lock();
    if (m_impl->m_readwritelcks < 0)
        m_impl->m_readwritelcks = 0;
    else
        m_impl->m_readwritelcks--;

    waiting_readers = (m_impl->m_wait_wrtr == 0);
    waiting_writers = ((m_impl->m_readwritelcks == 0) && m_impl->m_wait_wrtr);

    m_impl->m_mutex.unlock();

    // priority to writers
    if (waiting_writers)
        m_impl->m_wait_writers.signal();
    else if (waiting_readers)
        m_impl->m_wait_readers.broadcast();
}

