/////////////////////////////////////////////
// Copyright (c) Panos Kougiouris 1997
/////////////////////////////////////////////


#include <kfReferenceCount.h>
#include <assert.h>


CKFReferenceCount::CKFReferenceCount()
{
    m_count = 1;
    pthread_mutex_init(&m_mutex, NULL);
}

//-------------------------------------------

CKFReferenceCount::~CKFReferenceCount()
{
    assert(m_count == 0);
    pthread_mutex_destroy(&m_mutex);
}

//-------------------------------------------

void 
CKFReferenceCount::increment()
{
    pthread_mutex_lock(&m_mutex);
    m_count++;
    pthread_mutex_unlock(&m_mutex);
}

//-------------------------------------------

void 
CKFReferenceCount::decrement()
{
    pthread_mutex_lock(&m_mutex);
    m_count--;
    if (m_count == 0) {
        delete this;
    } else {
        pthread_mutex_unlock(&m_mutex);
    }
}

//-------------------------------------------

int 
CKFReferenceCount::count()
{
    int ret;

    pthread_mutex_lock(&m_mutex);
    ret = m_count;
    pthread_mutex_unlock(&m_mutex);

    return ret;
}


