///////////////////////////////////////////////////////////////////////////
// Copyright (c) Panos Kougiouris 1997
///////////////////////////////////////////////////////////////////////////

#include <kfThread.h>
#include <kfReferenceCount.h>

#include "kfMutexPosix.h" 

//--------------------------------------------------------

CKFMT::CMutex::CMutex(const char* a_name)
{
    m_impl = new CKFMTMutexImplementation(a_name);  
}

//--------------------------------------------------------

CKFMT::CMutex::CMutex(const CMutex& a_m)
{
    m_impl = a_m.m_impl;
    m_impl->increment();
}

//--------------------------------------------------------

CKFMT::CMutex& 
CKFMT::CMutex::operator= (const CKFMT::CMutex& a_m)
{ 
    m_impl->decrement();
    m_impl = a_m.m_impl;
    m_impl->increment();

    return *this;
}

//--------------------------------------------------------

CKFMT::CMutex::~CMutex()
{
    m_impl->decrement();
}

//--------------------------------------------------------

CKFMT::RetValue
CKFMT::CMutex::lock()
{
    int ret = pthread_mutex_lock(&m_impl->m_mutex);
    if (ret != 0) {
        return Error;
    } 
    m_impl->m_last_owner =  pthread_self();
    return Ok;
}

//--------------------------------------------------------

CKFMT::RetValue
CKFMT::CMutex::try_lock()
{
    int ret = pthread_mutex_trylock(&m_impl->m_mutex);
    if (ret == EBUSY) {
        return AlreadyLocked ;
    } else if (ret != 0) {
        return Error;
    }
    m_impl->m_last_owner =  pthread_self();
    return Ok;
}

//--------------------------------------------------------

CKFMT::RetValue
CKFMT::CMutex::unlock()
{
    m_impl->m_last_owner = -1;
    int ret = pthread_mutex_unlock(&m_impl->m_mutex);
    if (ret != 0) {
        return Error;
    }
    return Ok;
}

CKFBool
CKFMT::CMutex::am_owner()
{
    return (CKFBool) (m_impl->m_last_owner == pthread_self());
}
