#include <kfThread.h>
#include "list.h"

// pool of resources
list pool;

//---------------------------------------------
// producer class
//
class producer: public CKFMT::CRunnable {
public:
    producer(long howmany, list *lst);

    void run();

private:
    long  m_max;
    list *m_lst;
};

producer::producer(long howmany, list *lst)
{
    m_max = howmany;
    m_lst = lst;
}

void
producer::run()
{
    for(int i=0; i < m_max; i++) {
    long *rs = new long;
    *rs = i;
    m_lst->insert((void *)rs);

    for(int j=0; j < 3000; j++);
    }
    cerr << "Produced " << m_max << " resources.\n";
}

//---------------------------------------------
// consumer class
//
class consumer : public CKFMT::CRunnable {
public:
    consumer(list *lst);

    void run();

    long count() { return m_count; };

private:
    list *m_lst;
    long  m_count;

};

consumer::consumer(list *lst)
{
    m_lst = lst;
    m_count = 0;
}

void 
consumer::run()
{
    for(;;) {
    long *rv = (long *)m_lst->get();
    if (rv == NULL) {
        cerr << "Consumed " << m_count << " resources.\n";
        return;
    }
    else {
         delete rv;
         m_count++;

         if ((m_count % 50) == 0)
        cerr << "Consumed " << m_count << " resources.\n";
    }
    }
}

int 
main(int argc, char **argv)
{

    // start consumer
    consumer *con = new consumer(&pool);
    con->increment();
    CKFMT::CThread *cont = new CKFMT::CThread(con);
    cont->make_runnable();

    // start 2 producers
    // start producer # 1
    producer *prod1 = new producer(200, &pool);
    prod1->increment();
    CKFMT::CThread *prodt1 = new CKFMT::CThread(prod1);
    prodt1->make_runnable();

    // start producer #2
    producer *prod2 = new producer(100, &pool);
    prod2->increment();
    CKFMT::CThread *prodt2 = new CKFMT::CThread(prod2);
    prodt2->make_runnable();

    prod1->wait_for_completion();
    prod2->wait_for_completion();
    con->wait_for_completion();
}
