[Caption: Listing 4 -- CPU family 8051, Compiler IAR. Compiler dependent
definements in iohw.h]

#define access8 volatile unsigned char *

#define iowr8( PID, PVAL ) ( PID = ( PVAL ))
#define iord8( PID ) (( PID ))

#define XDATA ( (access8) 0x10000L ) 
       // MSB defines memory address space

//** Definement of I/O registers in iohw_ta.h  
// Memory mapped address space 
#define PORT1 (( XDATA [ 0xD803 ] )) 

// Register mapped address space 
sfr PORT2 = 0x90


//** Driver module
include <iohw.h>

void my_func(char val)
   {
   if (iord8(PORT2) & 0x40)
      iowr8(PORT1,val);
   else
      iowr8(PORT1, (iord8(PORT1) & 0xf) | val);
   }
