//**************************************************************************
// Application Module : TRACKER.H
//
// Description :	Header file for our system message tracker.
//
// Creator :  		Paul D. Carlson
// Date :  		2/05/97
//**************************************************************************

#include <stdlib.h>
#include <stdio.h>
#include <sys\timeb.h>

// Local Defines.
#define LOGFILENAME_SIZE	128

// Function Prototypes.
LRESULT CALLBACK _export JournalRecordProc(int code, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK _export JournalPlaybackProc(int code, WPARAM wParam, LPARAM lParam);

int checkFileHandle(void);
void closeLogFile(void);
long elaspedTime(struct timeb *, struct timeb *);
int initLogFile(void);
int logger(LPEVENTMSG, long);
int openLogFile(int access_mode);
void reader(EVENTMSG *, long *);
int readLogFile(EVENTMSG *, long *);
int FAR PASCAL _export startPlayback(char far *, int);
int FAR PASCAL _export startRecording(char far *);
void stopPlayback(void);
void FAR PASCAL _export stopRecording(void);
int writeLogFile(LPEVENTMSG, long);

// Module variable declarations

HOOKPROC		recordProc = 0;
HHOOK			hhRecordProc = 0;
HOOKPROC		playbackProc = 0;
HHOOK			hhPlaybackProc = 0;
HINSTANCE		ghInstance= 0;

HFILE			logFileHandle = 0;
char			logFileName[129];
int			iterations = 0;

struct timeb 		lastTimeMark;
long			readOffSet = 0;
