//class SpettroPlot containing graphical routines

class SpettroPlot
{

public:
    TColor *colore;
    struct
    {
        char sbxmin[10];
        char sbxmax[10];
        char sbymin[10];
        char sbymax[10];
    } tbzoom;          //Zoom buffer
private:
    float xmi,xma,ymi,yma, // plot extremes
          sx,sy,           // x and y scales
          ox,oy,           // x-y origin
          px,py,           // dot coordinates
          lx,ly;           // x and y range
                           // (lx=xma-xmi,
                           //  ly=yma-ymi)
                           
    float *xticks,*yticks,*divider;
    int ncp,i,col,
        w,h;               // physical width,
                           // height of device
                           // window
    TPoint p;
    TFont *fnt1;
    TWindow *parent;       // parent window
                           // address 
    LOGFONT lf;            // text font
    ListaSpettri *ls1;     // points to plot


public:
    SpettroPlot(TWindow *father,
                ListaSpettri *ls);
    ~SpettroPlot();
    float Xmi();     // return contents of xmi
    float Xma();     // "      "        "  xma
    float Ymi();     // "      "        "  ymi
    float Yma();     // "      "        "  yma
    
    ScalaXY ReturnScale(); // return sx,sy values
                           // in ScalaXY struct
    void GetClientSize(int width,int height);
    void Parameters();
    void ZParameters(float a, float b, float c, float d);
    void Plot(TDC *dc);
    void Axes(TDC *dc);
    void HorLine(TDC *dc, int y);
    void VerLine(TDC *dc, int x);
    void Ticks();
    void Clear();
    ListaSpettri* RitornaLista();
};
