#include "main.h"

///////////////////////////////////////////////////////////
// TWndwPrintout::TWndwPrintout()
//
// This is the printout object's constructor.
///////////////////////////////////////////////////////////
TWndwPrintout::TWndwPrintout(const char *title,
	TWindow *w) : TPrintout(title)
{
	// Save the window pointer for later.
	tw = w;
}

///////////////////////////////////////////////////////////
// TWndwPrintout::PrintPage()
//
// This function is called once for each page of the
// document. It is here that the program creates the image
// that is to appear on the printer.
///////////////////////////////////////////////////////////
void TWndwPrintout::PrintPage(int, TRect &rect, unsigned)
{
	TSize  oldVpExt, oldWndExt;

	int prevMode = DC->SetMapMode(MM_ISOTROPIC);

	TRect wndSize = tw->GetClientRect();

	DC->SetWindowExt(wndSize.Size(), &oldWndExt);

	DC->SetViewportExt(PageSize, &oldVpExt);

	tw->Paint(*DC, FALSE, rect);

	DC->SetWindowExt(oldWndExt);
	DC->SetViewportExt(oldVpExt);
	DC->SetMapMode(prevMode);
}

void TWndwPrintout::GetDialogInfo(int &minPage,
				 int &maxPage, int &selFromPage, int &selToPage)
{
  minPage=0;
  maxPage=0;
  selFromPage=0;
  selToPage=0;
}
