#include "main.h"
extern char *cd; //current directory

TColor customColors[16] =
		{
			0x010101L, 0x101010L, 0x202020L, 0x303030L,
			0x404040L, 0x505050L, 0x606060L, 0x707070L,
			0x808080L, 0x909090L, 0xA0A0A0L, 0xB0B0B0L,
			0xC0C0C0L, 0xD0D0D0L, 0xE0E0E0L, 0xF0F0F0L
		};

// generic Dialog Box classes


DEFINE_RESPONSE_TABLE1(TDlg,TDialog)
	 EV_LBN_SELCHANGE(IDC_LISTBOX1,EvListBoxSelChange),
	 EV_BN_CLICKED(IDC_PUSHBUTTON1,EvPushButtonAllign),
	 EV_BN_CLICKED(IDC_CHECKBOX1,EvCheckBox1),
	 EV_BN_CLICKED(IDC_CHECKBOX2,EvCheckBox2),
	 EV_BN_CLICKED(IDC_RADIOBUTTON3,EvRadioButton1),
	 EV_BN_CLICKED(IDC_RADIOBUTTON4,EvRadioButton2),
	 EV_BN_CLICKED(IDC_RADIOBUTTON5,EvRadioButton3),
	 EV_BN_CLICKED(IDC_COLBUT0,EvColBut0),
	 EV_BN_CLICKED(IDC_COLBUT1,EvColBut1),
	 EV_BN_CLICKED(IDC_COLBUT2,EvColBut2),
	 EV_BN_CLICKED(IDC_COLBUT3,EvColBut3),
	 EV_BN_CLICKED(IDC_COLBUT4,EvColBut4),
	 EV_BN_CLICKED(IDC_COLBUT5,EvColBut5),
	 EV_BN_CLICKED(IDC_COLBUT6,EvColBut6),
	 EV_BN_CLICKED(IDC_COLBUT7,EvColBut7),
	 EV_BN_CLICKED(IDC_COLBUT8,EvColBut8),
	 EV_BN_CLICKED(IDC_COLBUT9,EvColBut9),
	 EV_BN_CLICKED(IDC_COLBUT10,EvColBut10),
END_RESPONSE_TABLE;

///////////////////////////////////////////////////////////
//TDlg::TDlg()
//
//main constructor
//
//////////////////////////////////////////////////////////
TDlg::TDlg(TWndw* parent, TResId resID, int ns):
				TDialog(parent,resID)
{
 memset(&tbpar,0,sizeof(tbpar));
 memset(&tbconv,0,sizeof(tbconv));
 memset(&tbpick,0,sizeof(tbpick));
 memset(&tbint,0,sizeof(tbint));
 memset(&tbline,0,sizeof(tbline));
 memset(&tbpref,0,sizeof(tbpref));
 tipo_dialogo=resID;
 genitore=parent;
 numero=ns;
 int i;
 if (tipo_dialogo==TResId(DIALOG_1))
	{
		edit=new TEdit(this,IDC_EDIT1,sizeof(genitore->ll->sbt));
		valid=new TFilterValidator("0-9");
		edit->SetValidator(valid);
		TransferBuffer=&(genitore->ll->sbt);
	}
	else if (tipo_dialogo==TResId(DIALOG_2))
	{
		ck1=new TCheckBox(this,IDC_CHECKBOX1,0);
		ck2=new TCheckBox(this,IDC_CHECKBOX2,0);
		editgauss=new TEdit(this,IDC_EDIT2,sizeof(tbconv.sb_g));
		editlor=new TEdit(this,IDC_EDIT3,sizeof(tbconv.sb_l));
		vgauss=new TFilterValidator("0-9 .");
		vlor=new TFilterValidator("0-9 .");
		editgauss->SetValidator(vgauss);
		editlor->SetValidator(vlor);
		TransferBuffer=&tbconv;
	}
	else if (tipo_dialogo==TResId(DIALOG_3))
	{
		editxmin=new TEdit(this,IDC_XMIN,sizeof(genitore->pl->tbzoom.sbxmin));
		editxmax=new TEdit(this,IDC_XMAX,sizeof(genitore->pl->tbzoom.sbxmax));
		editymin=new TEdit(this,IDC_YMIN,sizeof(genitore->pl->tbzoom.sbymin));
		editymax=new TEdit(this,IDC_YMAX,sizeof(genitore->pl->tbzoom.sbymax));
		vxmin=new TFilterValidator("0-9 .+-");
		vxmax=new TFilterValidator("0-9 .+-");
		vymin=new TFilterValidator("0-9 .+-");
		vymax=new TFilterValidator("0-9 .+-");
		editxmin->SetValidator(vxmin);
		editxmax->SetValidator(vxmax);
		editymin->SetValidator(vymin);
		editymax->SetValidator(vymax);
		TransferBuffer=&(genitore->pl->tbzoom);
	}
	else if (tipo_dialogo==TResId(DIALOG_4))
	{
		lista_di_spettri=new TListBox(this,IDC_LISTBOX1);
	 }
	else if (tipo_dialogo==TResId(DIALOG_5))
	{
		edgain=new TEdit(this,IDC_GAIN,sizeof(tbpar.sbgain));
		edxshift=new TEdit(this,IDC_XSHIFT,sizeof(tbpar.sbxshift));
		edyshift=new TEdit(this,IDC_YSHIFT,sizeof(tbpar.sbyshift));
		tr1=new TRadioButton(this,IDC_RADIOBUTTON1,0);
		tr2=new TRadioButton(this,IDC_RADIOBUTTON2,0);
		vgain=new TFilterValidator("0-9 .+-");
		vxshift=new TFilterValidator("0-9 .+-");
		vyshift=new TFilterValidator("0-9 .+-");
		edgain->SetValidator(vgain);
		edxshift->SetValidator(vxshift);
		edyshift->SetValidator(vyshift);
		TransferBuffer=&tbpar;
	 }
	else if (tipo_dialogo==TResId(DIALOG_6))
	{
		lbn1=new TListBox(this,IDC_LISTBOX2);
		lbn2=new TListBox(this,IDC_LISTBOX3);
		rn1=new TRadioButton(this,IDC_RADIOBUTTON3,0);
		rn2=new TRadioButton(this,IDC_RADIOBUTTON4,0);
		rn3=new TRadioButton(this,IDC_RADIOBUTTON5,0);
		editnor=new TEdit(this,IDC_EDIT4,sizeof(tbnor.sb_3));
		vnor=new TFilterValidator("0-9 .+-");
		editnor->SetValidator(vnor);
		TransferBuffer=&tbnor;
	}
	else if (tipo_dialogo==TResId(DIALOG_7))
	{
	  edleft=new TEdit(this,IDC_EDIT5,sizeof(tbpick.sb_left));
	  edright=new TEdit(this,IDC_EDIT6,sizeof(tbpick.sb_right));
	  vleft=new TFilterValidator("0-9 .+-");
	  vright=new TFilterValidator("0-9 .+-");
	  edleft->SetValidator(vleft);
	  edright->SetValidator(vright);
	  TransferBuffer=&tbpick;
	}
	else if (tipo_dialogo==TResId(DIALOG_8))
	{
	  edleft=new TEdit(this,IDC_EDIT81,sizeof(tbint.sb_left));
	  edstep=new TEdit(this,IDC_EDIT82,sizeof(tbint.sb_step));
	  edright=new TEdit(this,IDC_EDIT83,sizeof(tbint.sb_right));
	  rb81=new TRadioButton(this,IDC_RADIOBUTTON81,0);
	  rb82=new TRadioButton(this,IDC_RADIOBUTTON82,0);
	  vleft=new TFilterValidator("0-9 .+-");
	  vstep=new TFilterValidator("0-9 .+-");
	  vright=new TFilterValidator("0-9 .+-");
	  edleft->SetValidator(vleft);
	  edstep->SetValidator(vstep);
	  edright->SetValidator(vright);
	  TransferBuffer=&tbint;
	}
	else if (tipo_dialogo==TResId(DIALOG_9))
	{
		las1=new TListBox(this,IDC_LISTBOX2);
		las2=new TListBox(this,IDC_LISTBOX3);
		TransferBuffer=&tbadsu;
	}
	else if (tipo_dialogo==TResId(DIALOG_10))
	{
		rb101=new TRadioButton(this,IDC_RADIOBUTTON101,0);
		rb102=new TRadioButton(this,IDC_RADIOBUTTON102,0);
		TransferBuffer=&tbbs;
	}
	else if (tipo_dialogo==TResId(DIALOG_11))
	{
		b[0]=new TButton(this,IDC_COLBUT0,0);
		b[1]=new TButton(this,IDC_COLBUT1,0);
		b[2]=new TButton(this,IDC_COLBUT2,0);
		b[3]=new TButton(this,IDC_COLBUT3,0);
		b[4]=new TButton(this,IDC_COLBUT4,0);
		b[5]=new TButton(this,IDC_COLBUT5,0);
		b[6]=new TButton(this,IDC_COLBUT6,0);
		b[7]=new TButton(this,IDC_COLBUT7,0);
		b[8]=new TButton(this,IDC_COLBUT8,0);
		b[9]=new TButton(this,IDC_COLBUT9,0);
		b[10]=new TButton(this,IDC_COLBUT10,0);
	}
	else if (tipo_dialogo==TResId(DIALOG_12))
	{
			 for (i=0;i<10;i++) edlp[i]=new TEdit(this,151+i,sizeof(tbline.lp[i]));
			 for (i=0;i<10;i++) edpth[i]=new TEdit(this,161+i,sizeof(tbline.spth[i]));
			 for (i=0;i<10;i++) edlth[i]=new TEdit(this,171+i,sizeof(tbline.slth[i]));
			 for (i=0;i<10;i++) edfn[i]=new TEdit(this,181+i,sizeof(tbline.fn[i]));
			 for (i=0;i<10;i++) vlp[i]=new TFilterValidator("lp");
			 for (i=0;i<10;i++) vpth[i]=new TFilterValidator("0-9 ");
			 for (i=0;i<10;i++) vlth[i]=new TFilterValidator("0-9 ");
			 for (i=0;i<10;i++) edlp[i]->SetValidator(vlp[i]);
			 for (i=0;i<10;i++) edpth[i]->SetValidator(vpth[i]);
			 for (i=0;i<10;i++) edlth[i]->SetValidator(vlth[i]);
			 TransferBuffer=&tbline;
	}
	else if (tipo_dialogo==TResId(DIALOG_13))
	{
			rb131=new TRadioButton(this,IDC_RADIOLINE,0);
			rb132=new TRadioButton(this,IDC_RADIOPOINT,0);
			edlinth=new TEdit(this,IDC_LINETH,sizeof(tbpref.sb_lineth));
			edpoth=new TEdit(this,IDC_POINTTH,sizeof(tbpref.sb_pointth));
			edwordir=new TEdit(this,IDC_WORDIR,sizeof(tbpref.sb_wordir));
			vlinth=new TFilterValidator("0-9 ");
			vpoth=new TFilterValidator("0-9 ");
			edlinth->SetValidator(vlinth);
			edpoth->SetValidator(vpoth);
			TransferBuffer=&tbpref;
	 }
}

TDlg::~TDlg()
{
int i;
if (tipo_dialogo==TResId(DIALOG_1))
	{
		delete edit;
	}
	else if (tipo_dialogo==TResId(DIALOG_2))
	{
		delete ck1;
		delete ck2;
		delete editgauss;
		delete editlor;
	}
	else if (tipo_dialogo==TResId(DIALOG_3))
	{
		delete editxmin;
		delete editxmax;
		delete editymin;
		delete editymax;
	}
	else if (tipo_dialogo==TResId(DIALOG_4))
	{
		delete lista_di_spettri;
	 }
	else if (tipo_dialogo==TResId(DIALOG_5))
	{
		delete edgain;
		delete edxshift;
		delete edyshift;
		delete tr1;
		delete tr2;
	 }
	 else if (tipo_dialogo==TResId(DIALOG_6))
	 {
		delete rn1;
		delete rn2;
		delete rn3;
		delete editnor;
		delete lbn1;
		delete lbn2;
	 }
	 else if (tipo_dialogo==TResId(DIALOG_7))
	 {
		delete edleft;
		delete edright;
	 }
	else if (tipo_dialogo==TResId(DIALOG_8))
	 {
		delete edleft;
		delete edstep;
		delete edright;
		delete rb81;
		delete rb82;
	 }
	else if (tipo_dialogo==TResId(DIALOG_9))
	 {
		delete las1;
		delete las2;
	 }
	 else if (tipo_dialogo==TResId(DIALOG_10))
	 {
		delete rb101;
		delete rb102;
	 }
	 else if (tipo_dialogo==TResId(DIALOG_11))
		for (i=0;i<=10;i++) delete b[i];
	 else if (tipo_dialogo==TResId(DIALOG_12))
		for (i=0;i<10;i++)
		  {
			 delete edlp[i];
			 delete edpth[i];
			 delete edlth[i];
			 delete edfn[i];
		  }
	  else if (tipo_dialogo==TResId(DIALOG_13))
	  {
		 delete rb131;
		 delete rb132;
		 delete edlinth;
		 delete edpoth;
		 delete edwordir;
	  }
}

void TDlg::SetupWindow()
{

	 TDialog::SetupWindow();
	 int i;
	 if (tipo_dialogo==TResId(DIALOG_4))
	 {
		for (i=1;i<=genitore->ll->NSpettri();i++)
			lista_di_spettri->AddString(genitore->ll->GiveElement(i)->NomeFile());
	 }
	 else if (tipo_dialogo==TResId(DIALOG_6))
	 {
		lbn1->SetColumnWidth(400);
		lbn2->SetColumnWidth(400);
		lbn1->SetHorizontalExtent(400);
		lbn2->SetHorizontalExtent(400);
		int nmr=genitore->ll->ReturnMarked();
		if (nmr>0)
			tbnor.lbd1.AddString(genitore->ll->GiveElement(nmr)->NomeFile(),TRUE);
		else for (i=1;i<=genitore->ll->NSpettri();i++)
			tbnor.lbd1.AddString(genitore->ll->GiveElement(i)->NomeFile());
		for (i=1;i<=genitore->ll->NSpettri();i++)
			tbnor.lbd2.AddString(genitore->ll->GiveElement(i)->NomeFile());
		tbnor.radio_1=TRUE;
		tbnor.radio_2=FALSE;
		tbnor.radio_3=FALSE;
		strcpy(tbnor.sb_3,"");
		TransferData(tdSetData);
	 }
	 else if (tipo_dialogo==TResId(DIALOG_8))
	 {
		rb81->Check();
		rb82->Uncheck();
	 }
	 else if (tipo_dialogo==TResId(DIALOG_9))
	 {
		las1->SetColumnWidth(400);
		las2->SetColumnWidth(400);
		las1->SetHorizontalExtent(400);
		las2->SetHorizontalExtent(400);
		int nmr=genitore->ll->ReturnMarked();
		if (nmr>0)
			tbadsu.lbd1.AddString(genitore->ll->GiveElement(nmr)->NomeFile(),TRUE);
		else for (i=1;i<=genitore->ll->NSpettri();i++)
			tbadsu.lbd1.AddString(genitore->ll->GiveElement(i)->NomeFile());
		for (i=1;i<=genitore->ll->NSpettri();i++)
			tbadsu.lbd2.AddString(genitore->ll->GiveElement(i)->NomeFile());
		TransferData(tdSetData);
	 }
	 else if (tipo_dialogo==TResId(DIALOG_10))
	 {
		rb101->Check();
		rb102->Uncheck();
	 }
	 else if (tipo_dialogo==TResId(DIALOG_11))
		for (i=0;i<=10;i++)
			 b[i]->SetBkgndColor(COLORREF(genitore->pl->colore[i]));
	 else if (tipo_dialogo==TResId(DIALOG_12))
	 {
		 //preparing the transfer buffer
		 for (i=0;i<10;i++)
			 {
				if  (genitore->ll->ReturnLineType(i+1)==ST_LINE)
						 strcpy(tbline.lp[i],"l");
				else  strcpy(tbline.lp[i],"p");
				sprintf(tbline.spth[i],"%2d",genitore->ll->ReturnCerchio(i+1));
				sprintf(tbline.slth[i],"%2d",genitore->ll->ReturnPenWidth(i+1));
				if (i<genitore->ll->NSpettri())
					strcpy(tbline.fn[i],genitore->ll->GiveElement(i+1)->NomeFile());
				else  strcpy(tbline.fn[i],"");
			 }
		 TransferData(tdSetData);
	  }
	  else if (tipo_dialogo==TResId(DIALOG_13))
	  {
		 tbpref.radio_point=TRUE;
		 tbpref.radio_line=FALSE;
		 if (genitore->ll->pref_style==ST_LINE)
		 {
			tbpref.radio_point=FALSE;
			tbpref.radio_line=TRUE;
		 }
		 sprintf(tbpref.sb_lineth,"%2d",genitore->ll->lth);
		 sprintf(tbpref.sb_pointth,"%2d",genitore->ll->pth);
		 strcpy(tbpref.sb_wordir,cd);
		 TransferData(tdSetData);
	  }
}



void TDlg::EvListBoxSelChange()
{
	lista_di_spettri->GetSelString(file_selezionato,sizeof(file_selezionato));
}


void TDlg::EvPushButtonAllign()
{
  if (numero>0)
  {
	 TransferData(tdGetData);
	 sprintf(tbpar.sbyshift,"%8.1f",
			-(genitore->ll->GiveElement(numero)->Minimo()));
	 TransferData(tdSetData);
  }
}

void TDlg::EvCheckBox1()
{
  TransferData(tdGetData);
  if (tbconv.check_g==TRUE) {editgauss->Show(SW_SHOW);editgauss->SetFocus();}
  else {editgauss->Show(SW_HIDE);memset(&tbconv.sb_g,0,sizeof(tbconv.sb_g));}
}

void TDlg::EvCheckBox2()
{
  TransferData(tdGetData);
  if (tbconv.check_l==TRUE) {editlor->Show(SW_SHOW);editlor->SetFocus();}
  else {editlor->Show(SW_HIDE);memset(&tbconv.sb_l,0,sizeof(tbconv.sb_l));}

}

void TDlg::EvRadioButton1()
{
  editnor->Show(SW_HIDE);
}

void TDlg::EvRadioButton2()
{
  editnor->Show(SW_HIDE);
}

void TDlg::EvRadioButton3()
{
  editnor->Show(SW_SHOW);
  editnor->SetFocus();
}

void TDlg::EvColBut0()
{
  SelCol(0);
}

void TDlg::EvColBut1()
{
  SelCol(1);
}

void TDlg::EvColBut2()
{
  SelCol(2);
}

void TDlg::EvColBut3()
{
  SelCol(3);
}

void TDlg::EvColBut4()
{
  SelCol(4);
}

void TDlg::EvColBut5()
{
  SelCol(5);
}

void TDlg::EvColBut6()
{
  SelCol(6);
}

void TDlg::EvColBut7()
{
  SelCol(7);
}

void TDlg::EvColBut8()
{
  SelCol(8);
}

void TDlg::EvColBut9()
{
  SelCol(9);
}

void TDlg::EvColBut10()
{
  SelCol(10);
}

void TDlg::SelCol(int nc)
{
	TColor chosencolor=genitore->pl->colore[nc];
	TChooseColorDialog::TData colorData;
	colorData.Flags = CC_FULLOPEN | CC_RGBINIT;
	colorData.Color = chosencolor;
	colorData.CustColors = customColors;

	// Create the Color dialog box.
	TChooseColorDialog *coldia =
	  new TChooseColorDialog(this, colorData);

	int result = coldia->Execute();
	if (result == IDOK)
	{
		genitore->pl->colore[nc]=colorData.Color;
		b[nc]->SetBkgndColor(COLORREF(colorData.Color));
		b[nc]->Invalidate();
	}
	delete coldia;
}

