#include "spettro.h"

#include "cwp.h"

SpettroMat::SpettroMat():Spettro() {}

//creatore di coppia
SpettroMat::SpettroMat(const SpettroMat &sm):Spettro(sm){}

SpettroMat& SpettroMat::operator=(const SpettroMat &sm)
{
  Spettro::operator=(Spettro(sm));
  return *this;
}

void SpettroMat::Gain(float g)
{
  for (PuntaCoppia pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) pc1->y*=g;
}


void SpettroMat::XShift(float xs)
{
  for (PuntaCoppia pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) pc1->x+=xs;
}

void SpettroMat::YShift(float ys)
{
  for (PuntaCoppia pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) pc1->y+=ys;
}


void SpettroMat::XSign()
{
  for (PuntaCoppia pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) pc1->x*=-1;
  if (TrovaX(2)<TrovaX(1)) Invert();
}



float SpettroMat::Norma(SpettroMat &sm2)
{
	float m1,m2,n;
	m1=Massimo();
	m2=sm2.Massimo();
	if (m1!=0)
	{
	  n=m2/m1;
	  for (PuntaCoppia pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) pc1->y*=n;
	  return n;
	}
	else return 1;
}

float SpettroMat::NormArea(SpettroMat &sm2)
{
  float a1,a2,n;
  a1=Area();
  a2=sm2.Area();
  if (a1!=0)
	{
	  n=a2/a1;
	  for (PuntaCoppia pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) pc1->y*=n;
	  return n;
	}
	else return 1;
}

float SpettroMat::NormaPoint(SpettroMat &sm2,float p)
{
  float v1,v2,n,x1,x2;
  unsigned int found1,found2;
  found1=0;
  found2=0;
  PuntaCoppia pc1;
  v1=0;
  v2=0;
  x1=TrovaX(1);
  for (pc1=primo;pc1!=ultimo;pc1=Shift(pc1))
  {
	 x2=pc1->x;
	 if((x1-p)*(x2-p)<=0) {v1=pc1->y;found1=1;break;}
	 x1=x2;
  }
  x1=sm2.TrovaX(1);
  for (pc1=sm2.primo;pc1!=sm2.ultimo;pc1=Shift(pc1))
  {
	 x2=pc1->x;
	 if((x1-p)*(x2-p)<=0) {v2=pc1->y;found2=1;break;}
	 x1=x2;
  }
  if ((v1!=0)&&(found1)&&(found2))
	{
	  n=v2/v1;
	  for (pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) pc1->y*=n;
	  return n;
	}
	else return 1;
}


float SpettroMat::Area()
{
  float a,step,fst,snd;
  a=0;
  snd=TrovaX(1);
  for (PuntaCoppia pc1=primo;pc1!=ultimo;pc1=Shift(pc1))
	 {
		fst=snd;
		snd=pc1->x;
		step=snd-fst;
		a+=step*pc1->y;
	  }
  return fabs(a);
}

void SpettroMat::Pick(float left, float right)
{
 PuntaCoppia pc1;
 if (left>right){float temp=left;left=right; right=temp;}

 SpettroMat temp;  //spettro vuoto
 for (pc1=primo;pc1!=ultimo;pc1=Shift(pc1))
	if ((pc1->x>=left)&&(pc1->x<=right)) temp.XY(pc1->x,pc1->y);
 Svuota();       //svuoto lo spettro originale
 for (pc1=temp.primo;pc1!=temp.ultimo;pc1=Shift(pc1))
	XY(pc1->x,pc1->y);
}

void SpettroMat::Derive()
{
  float x0,y0,x1,y1;
  PuntaCoppia pc1;
  x0=TrovaX(1);
  y0=TrovaY(1);
  for (pc1=primo;pc1!=ultimo;pc1=Shift(pc1))
	 {x1=pc1->x;
	  y1=pc1->y;
	  if (x1!=x0) pc1->y=(y1-y0)/(x1-x0);
	  x0=x1;
	  y0=y1;}
  primo->y=TrovaY(2);
}

void SpettroMat::Integrate()
{
  float it=0;
  float x0=TrovaX(1);
  float x1;
  PuntaCoppia pc1;
  for (pc1=primo;pc1!=ultimo;pc1=Shift(pc1))
	 {x1=pc1->x;
	  it+=(x1-x0)*pc1->y;
	  pc1->y=it;
	  x0=x1;}
}





int SpettroMat::Convolution(float gw, float lw)
{
  int r=0;   //return value
  float *g,*l,*y,*z;
  float step=TrovaX(2)-TrovaX(1);
  int npg=floor(10*gw/step);   //x in the range -10gw - 10gw
  int npl=floor(10*lw/step);
  int fg=-floor(npg/2);
  int fl=-floor(npl/2);
  int nc=NumCoppie();
  int nmax;
  nmax=(npg>npl)?npg:npl;        //!!all vectore should be allocated the
  nmax=(nc>nmax)?nc:nmax;       //same length!!
  float l2=4*log(2);
  PuntaCoppia pc1;
  z=new float[nmax];
  y=new float[nmax];
  int i;


  if ((gw>0)&&(npg>4)&&(npg<1000))
	 {
		r=1;
		g=new float[nmax];
		float x,c;
		c=(0.9394*step)/gw;

		//load gaussian in g
		for (i=0;i<npg;i++)
		{
			 x=-5*gw +i*step;
			 g[i]=c*exp(-pow(x/gw,2)*l2);
		  }

		//load the spectrum in y
		i=0;
		for (pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) y[i++]=pc1->y;

		conv(npg,fg,g,nc,0,y,nc,0,z);

		//load z into the spectrum
		i=0;
		for (pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) pc1->y=z[i++];

		delete [] g;
	 }
	if ((lw>0)&&(npl>4)&&(npl<1000))
	 {
		r+=2;
		l=new float[nmax];
		float x,c;
		c=(0.6366*step)/lw;
		for (i=0;i<npl;i++)        //create lorentzian with npl points
		  {
			 x=-5*lw +i*step;
			 l[i]=c/(1+4*pow(x/lw,2));
		  }

		//load the spectrum in y
		i=0;
		for (pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) y[i++]=pc1->y;

		conv(npl,fl,l,nc,0,y,nc,0,z);

		//load z into the spectrum
		i=0;
		for (pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) pc1->y=z[i++];

		delete [] l;
	 }


	 delete [] y;
	 delete [] z;
	 return r;
}

int SpettroMat::Interpolate(int tipo,float left,float step, float right)
{
  float *x,*y,*xn,*yn,temp;
  typedef float RIGA[4];
  RIGA *yd;
  int nc,i,nout;
  PuntaCoppia pc1;
  if (left>right) {temp=left; left=right; right=temp;}
  if ((left>Xma())|(right<Xmi())|(step==0)) return 0;
  if ((right-left)/fabs(step)>2000) return 1;
  nc=NumCoppie();
  x=new float[nc];
  y=new float[nc];
  yd=new RIGA[nc];
  nout=floor((right-left)/fabs(step));  //final number of points
  xn=new float[nout];
  yn=new float[nout];

  //load the spectrum in x and y
  i=0;
  for (pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) {x[i]=pc1->x;y[i++]=pc1->y;}
  //prepare the final spectrum
  for (i=0;i<nout;i++) xn[i]=left+i*step;

  if (tipo==1)				//spline
  {
	 csplin(nc,x,y,yd);   //calculate the first 3 derivatives

	 intcub(0,nc,x,yd,nout,xn,yn);  //spline routine

	 //load the result in the current spectrum
	 Svuota();
	 for (i=0;i<nout;i++) XY(xn[i],yn[i]);
  }
  else               //linear interpolation
  {
	  float yleft=y[0],yright=y[nc-1];
	  intlin (nc,x,y,yleft,yright,nout,xn,yn);     //linear interpolation

	//load the result in the current spectrum
	 Svuota();
	 for (i=0;i<nout;i++) XY(xn[i],yn[i]);
  }
  delete[] x;
  delete[] y;
  delete[] xn;
  delete[] yn;
  delete[] yd;
  return 2;
}

int SpettroMat::Add(SpettroMat &sm2)
{
  float step1=TrovaX(2)-TrovaX(1);
  float step2=sm2.TrovaX(2)-sm2.TrovaX(1);
  if (step1*step2<=0) return 0;   //one spectrum is inverted
  PuntaCoppia pc1,pc2;
  int nc1=NumCoppie();
  int nc2=sm2.NumCoppie();
  float left1=TrovaX(1);
  float left2=sm2.TrovaX(1);
  float right1=TrovaX(nc1);
  float right2=sm2.TrovaX(nc2);
  if (left1>right1) {float t1=left1;left1=right1;right1=t1;}
  if (left2>right2) {float t2=left2;left2=right2;right2=t2;}
  if ((left1==left2)&&(right1==right2)&&(nc1==nc2))
		for (pc1=primo,pc2=sm2.primo;pc1!=ultimo;
			pc1=Shift(pc1),pc2=Shift(pc2)) pc1->y+=pc2->y;
  else
  {
		int res=sm2.Interpolate(0,left1,step1,right1);
		if (res!=2) return 1;     //impossible to interpolate
		for (pc1=primo,pc2=sm2.primo;pc1!=ultimo;
			pc1=Shift(pc1),pc2=Shift(pc2)) pc1->y+=pc2->y;
  }
  return 2;
}

int SpettroMat::Sub(SpettroMat &sm2)
{
  float step1=TrovaX(2)-TrovaX(1);
  float step2=sm2.TrovaX(2)-sm2.TrovaX(1);
  if (step1*step2<=0) return 0;   //one spectrum is inverted
  PuntaCoppia pc1,pc2;
  int nc1=NumCoppie();
  int nc2=sm2.NumCoppie();
  float left1=TrovaX(1);
  float left2=sm2.TrovaX(1);
  float right1=TrovaX(nc1);
  float right2=sm2.TrovaX(nc2);
  if (left1>right1) {float t1=left1;left1=right1;right1=t1;}
  if (left2>right2) {float t2=left2;left2=right2;right2=t2;}
  if ((left1==left2)&&(right1==right2)&&(nc1==nc2))
		for (pc1=primo,pc2=sm2.primo;pc1!=ultimo;
			pc1=Shift(pc1),pc2=Shift(pc2)) pc1->y-=pc2->y;
  else
  {
		int res=sm2.Interpolate(0,left1,step1,right1);
		if (res!=2) return 1;     //impossible to interpolate
		for (pc1=primo,pc2=sm2.primo;pc1!=ultimo;
			pc1=Shift(pc1),pc2=Shift(pc2)) pc1->y-=pc2->y;
  }
  return 2;
}

int SpettroMat::BackSub(int tipo)
{
  int nc=NumCoppie();
  int nit=0;  				//number of iterations
  float tol=1e-5;			//tolerance
  float y1,x1,ync,xnc,al,bl,c,err,yh,sh,denom;
  int nodo;
  PuntaCoppia pc1;
  y1=TrovaY(1);
  x1=TrovaX(1);
  ync=TrovaY(nc);
  xnc=TrovaX(nc);
  al=(ync-y1)/(xnc-x1);  	//coeff. of linear background
  bl=ync-al*xnc;

  SpettroMat tempbg;
  for (pc1=primo;pc1!=ultimo;pc1=Shift(pc1)) tempbg.XY(pc1->x,(pc1->x)*al+bl);
  if (tipo==0) {Sub(tempbg);return 0;}
  SpettroMat newbg(tempbg);   //copia
  SpettroMat temp(tempbg);

  err=1;
  nodo=(ync>y1)?1:nc;
  yh=TrovaY(nodo);
  while((err>tol)&&(nit<20))
  {
	 nit++;
	 tempbg=newbg;			//!overloaded =
	 newbg=*this;
	 newbg.Sub(tempbg);
	 newbg.Integrate();
	 sh=newbg.TrovaY(nodo);
	 denom=newbg.TrovaY(nc-nodo+1)-sh;
	 if (denom==0) return 0;
	 c=(TrovaY(nc-nodo+1)-yh)/denom;
	 newbg.YShift(-sh);
	 newbg.Gain(c);
	 newbg.YShift(yh);
	 temp=newbg;
	 temp.Sub(tempbg);
	 denom=newbg.TrovaY(nc-nodo+1);
	 if (denom==0) return 0;
	 err=fabs(temp.Massimo()/denom);
  }
  Sub(newbg);
  return nit;
}
