// collezione di classi per spettri

#if !defined SPETTRO_H
# define SPETTRO_H

#include <fstream.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#define FILE_NAME_LENGTH 50
#define MAX_SPECTRA 10

enum line_type{ST_POINT,ST_LINE};

struct Coppia;

typedef Coppia  *PuntaCoppia;

struct Coppia
{
	float x,y;
	PuntaCoppia puntcp;
};

struct ScalaXY
{
  float sx,sy,ox,oy;
};


class Spettro
{
	private:	int nCoppie;

	protected: PuntaCoppia ultimo,primo,temp,corrente;

	public:

	Spettro();   						//creatore di default

	Spettro(const Spettro& cc); 	//creatore di coppia

	~Spettro();							//distruttore

	private:
	PuntaCoppia  AggiungiCoppia(float a,float b,PuntaCoppia pcp);


	public:

	int XY(float a, float b);		//aggiunge una coppia e restituisce
											//il numero totale di coppie
	int NumCoppie();					//restituisce il numero di coppie;

	float Massimo();					//valore massimo dello spettro (y)

	float Minimo();					//valore minimo dello spettro (y)

	float Xmi();						//minimo di x

	float Xma();						//massimo di x

	float TrovaX(int j);				//valore di x della coppia j-esima

	float TrovaY(int j);          //valore di y della coppia j-esima

	Spettro operator *(float m);   	//moltiplicazione per m

	Spettro& operator =(const Spettro& sp); // copia dei valori di sp

	void CambiaXY(int j,float a,float b);  //campa la coppia j-esima

	PuntaCoppia Shift(PuntaCoppia pc){return pc->puntcp;};   //inline

	PuntaCoppia Rprimo() {return primo;};

	PuntaCoppia Rultimo() {return ultimo;};

	protected: void Svuota();    //svuota Spettro senza distruggerlo

	void Invert();  //inverte l'ordine dei punti
};


//classe SpettroMat che eredita da Spettro, aggiungendo alcune
//funzionalita' per la manipolazione dei dati

class SpettroMat: public Spettro
{
public:
	SpettroMat(); 	 //creatore

	SpettroMat(const SpettroMat &sm);  //creatore di coppia

	SpettroMat& operator=(const SpettroMat &sm);

	void Gain(float g);					// moltiplica per una costante

	void XSign();							//inverte le coordinate x

	void XShift(float xs);				//shift delle x-coordinate

	void YShift(float ys);				//shift delle y-coordinate

	int Convolution(float gw, float lw);  //gaussian-lorentzian convolution

	float Norma(SpettroMat &sm2); //normalizzione al max

	float Area(); //area della curva

	float NormArea(SpettroMat &sm2); //normalizzazione all'area

	float NormaPoint(SpettroMat &sm2,float p); //normalization in one point

	void Pick(float left, float right);   //coglie punti tra left e right

	void Derive(); //derivata prima

	void Integrate(); //integra

	int Interpolate(int tipo,float left,float step, float right); //interpolation

	int Add(SpettroMat &sm2);   //somma lo spettro corrente con sm2

	int Sub(SpettroMat &sm2);	//sottrae sm2 dallo spettro corrente

	int BackSub(int tipo);    //sottrae un fondo
};




//definisce la classe SpettroFile che eredita da SpettroMat
// e aggiungendo la possibilit di leggere i files.

class SpettroFile: public SpettroMat
{
  private: char*  nf;

  public:
  //costruttore
  SpettroFile(char* nomef="null");

  //costruttore di coppia
  SpettroFile(const SpettroFile& sf);


  //operatore sovraccaricato
  SpettroFile operator *(float m);

  SpettroFile& operator =(const SpettroFile &sf);


  // distruttore
  ~SpettroFile();

  //carica il file nomef nello Spettro in memoria
  int CaricaFile();

  int ImportVGX900();  //import files with vgx900 format

  void SalvaFile(char* nomef);

  char* NomeFile() const;

  void CambiaNome(char* nm);
};

#endif
