#include "spettro.h"
#include <strstrea.h>
#include <ctype.h>

SpettroFile::SpettroFile(char* nomef): SpettroMat()
	 {
		 nf=0;
		 nf=new char[FILE_NAME_LENGTH];
		 for(int i=0;i<=strlen(nomef);i++) nomef[i]=tolower(nomef[i]);
		 strncpy(nf,nomef,strlen(nomef)+1);
	 }


SpettroFile::SpettroFile(const SpettroFile& sf):SpettroMat(sf)
  {
	 nf=0;
	 nf=new char[FILE_NAME_LENGTH];
	 strncpy(nf,sf.NomeFile(),strlen(sf.NomeFile())+1);
  }

//operatore moltiplica sovraccarico
SpettroFile SpettroFile::operator*(float m)
{
		SpettroFile nuovo(" ");
		for (PuntaCoppia corrente=primo;corrente!=ultimo;
					corrente=Shift(corrente))
						nuovo.XY(corrente->x,m*corrente->y);
		return nuovo;
}

SpettroFile& SpettroFile::operator=(const SpettroFile &sf)
{
 Spettro::operator=(Spettro(sf));
 nf=0;
 nf=new char[FILE_NAME_LENGTH];
 strncpy(nf,sf.NomeFile(),strlen(sf.NomeFile())+1);
 return *this;
}

SpettroFile::~SpettroFile()
  {
	 if (nf) delete nf;
  }

char* SpettroFile::NomeFile() const
{
  return nf;
}


int SpettroFile::CaricaFile()
  {
	 float x,y;
	 char linea[81];
	 char *comma;
	 ifstream f1(nf);

	 if (f1){
	 while (f1.getline(linea,81))
		{
		  istrstream ins(linea,strlen(linea));
		  comma=strstr(linea,",");
		  if (comma!=NULL) *comma=' ';     //remove commas
		  ins>>x>>y;
		  //inserisce i dati
		  if ((strlen(linea)>1)&&(ins.fail()==0)) XY(x,y);
		}
	 }
	 if (TrovaX(2)<TrovaX(1)) Invert();
	 if (NumCoppie()>0) return 1; else return 0;
	}

int SpettroFile::ImportVGX900()
  {
	 float y,left,right,step;
	 char linea[81];
	 ifstream f1(nf);
	 if (f1){

	 f1.getline(linea,81);   //skip first line

	 f1.getline(linea,81);   //x-range informations
	 istrstream ins(linea,strlen(linea));
	 ins>>left>>right>>step;

	 f1.getline(linea,81);  //skip third line


	 while (f1.getline(linea,81))
		{
		  istrstream ins(linea,strlen(linea));
		  ins>>y;
		  //inserisce i dati
		  if ((strlen(linea)>1)&&(ins.fail()==0)) XY(left,y);
		  left+=step;
		}
	 }
	 if (TrovaX(2)<TrovaX(1)) Invert();
	 if (NumCoppie()>0) return 1; else return 0;
	}


void SpettroFile::SalvaFile(char* nomef)
  {
	 ofstream f1(nomef);
	 for (PuntaCoppia pc=primo;pc!=ultimo;pc=Shift(pc))
		f1<<pc->x<<"\t\t"<<pc->y<<"\n";
	}

void SpettroFile::CambiaNome(char* nm)
{
  for(int i=0;i<=strlen(nm);i++) nm[i]=tolower(nm[i]);
		 strncpy(nf,nm,strlen(nm)+1);
}


