#if !defined EXTRA_H
# define EXTRA_H
#include <owl\dc.h>
#include <owl\decframe.h>
#include <dir.h>
#include "spettro.h"

//Classe contenente gli spettri caricati in memoria
class ListaSpettri
{

private:
SpettroFile* lista[MAX_SPECTRA];
line_type ltp[MAX_SPECTRA];
float gain[MAX_SPECTRA];
float xshift[MAX_SPECTRA];
float yshift[MAX_SPECTRA];
int xsign[MAX_SPECTRA];
int cerchio[MAX_SPECTRA];
int pw[MAX_SPECTRA];
int n_elementi,marked;
TWindow *genitore;


public:
ListaSpettri(TWindow* parent); 	//creatore
~ListaSpettri();  //distruttore
void Svuota(); //empty the list
int NSpettri();   //numero di spettri caricati
int CaricaSpettro(char* nome, int load_type=0); //aggiungi uno spettro alla lista e
												 //restituisce l'indice di lista
int ReplicaSpettro(int ns); //copia spettrofile appendendolo
int ScaricaSpettro(int idx);         //scarica lo spettro in pos idx
									  //e restituisce il numero di spettri rimasti

void RicaricaSpettro (int idx); //ricarics lo spettro originale
void PutElement(int i,SpettroFile &sf); //inserisce


SpettroFile* GiveElement(int i);

void CaricaSGS(int i,float g,float xs,float ys, int xsg); //load file par.
float ReturnGain(int i);
float ReturnXShift(int i);
float ReturnYShift(int i);
int ReturnXSign(int i);
void SetCerchio(int i, int c);
int ReturnCerchio(int i);
void SetLineType(int i,line_type lp);
line_type ReturnLineType(int i);
void SetPenWidth(int i,int w);
int ReturnPenWidth(int i);
void MarkSpectrum(int i);
int ReturnMarked();
char sbt[3];   // Point Size buffer
line_type pref_style;
int lth,pth;
};

//classe SpettroPlot contenete le routines grafiche
class SpettroPlot
{

public:
	TColor *colore;
	struct
	{
		char sbxmin[10];
		char sbxmax[10];
		char sbymin[10];
		char sbymax[10];
	} tbzoom;	  			//Zoom buffer
private:
	float xmi,xma,ymi,yma,sx,
			sy,ox,oy,px,py,lx,ly;
	float *xticks,*yticks,*divider;
	int ncp,i,col,w,h;
	TPoint p;
	TFont *fnt1;
	TWindow *parent;
	LOGFONT lf;
	ListaSpettri* ls1;


public:
	SpettroPlot(TWindow* parent,ListaSpettri* ls);
	~SpettroPlot();
	float Xmi();
	float Xma();
	float Ymi();
	float Yma();
	ScalaXY ReturnScale();
	void GetClientSize(int width,int height);
	void Parameters();
	void ZParameters(float a, float b, float c, float d);
	void Plot(TDC *dc);
	void Axes(TDC *dc);
	void HorLine(TDC *dc, int y);
	void VerLine(TDC *dc, int x);
	void Ticks();
	void Clear();
	ListaSpettri* RitornaLista();

};

#endif