/* ----------------------------------------------------
 *  Filename:           sortlog.h
 *  Summary:            polyphase merge sort log header
 *  Author:             T.W. Nelson
 *  Compiler:           BCC++ 4.0
 *  Compile options:
 *  Start date:         30-Oct-1995
 *  Last update:        30-Oct-1995
 *  Version:            1.00
 *  Notes:
 *
 *  Source code Copyright (c) 1995 T.W. Nelson.
 *  This source (including derivations thereof) may
 *  be used in any manner provided this copyright
 *  notice is displayed appropriately in source.
 * ------------------------------------------------- */

#if !defined __SORTLOG_H
#define __SORTLOG_H

typedef unsigned long ulong;

#if !defined __PSORT_H && !defined NO_SORT_LOG
#include "psort.h"

ulong d_ItemsIn();
void d_SetItemsIn( ulong n );
int  d_RunsIn();
void d_SetRunsIn( int n );
int  d_RunsOut();
void d_SetRunsOut( int n );
long d_XferTotal();
void d_SetXferTotal( long n );
long d_XferCount();
void d_SetXferCount( long n);
void d_ResetLog();
void d_RunDistributionSummary( int,MergeList *, MergeFile * );
void d_DisplayRunsAtBegLevel( int, MergeList *, MergeFile * );
void d_DisplayRunsAtEndPass( MergeList *, MergeFile * );
void d_DisplayXferTotals();
void d_VerifySort( const char *,InternalSort *,MergeList *,MergeFile *);

#else

#define d_ItemsIn()                       ((void)0)
#define d_SetItemsIn(n)                   ((void)0)
#define d_RunsInput()                     ((void)0)
#define d_SetRunsIn(n)                    ((void)0)
#define d_RunsOutput()                    ((void)0)
#define d_SetRunsOut(n)                   ((void)0)
#define d_XferTotal()                     ((void)0)
#define d_SetXferTotal(n)                 ((void)0)
#define d_XferCount()                     ((void)0)
#define d_SetXferCount(n)                 ((void)0)
#define d_ResetLog()                      ((void)0)
#define d_RunDistributionSummary(a,b,c)   ((void)0)
#define d_DisplayRunsAtBegLevel(a,b,c)    ((void)0)
#define d_DisplayRunsAtEndPass(a,b)       ((void)0)
#define d_DisplayXferTotals()             ((void)0)
#define d_VerifySort(a,b,c,d)             ((void)0)

#endif
#endif

/* ----- EOF --------------------------------------- */
