/* ----------------------------------------------------
 *  Filename:           timer.h
 *  Summary:            stopwatch timer class
 *  Author:             T.W. Nelson
 *  Compiler:           BCC++ 4.0
 *  Compile options:    link with floating-point
 *  Start date:         31-Jan-1995
 *  Last update:        31-Jan-1995
 *  Version:            1.00
 *  Notes:
 *
 *  Source code adapted from CUJ Feb '95, pg. 99.
 * ------------------------------------------------- */

#ifndef __TIMER_H
#define __TIMER_H

#if !defined __TIME_H
#include <time.h>
#endif

//#pragma extref _floatconvert    //needed by BCC for DOS .EXE (?)

class Timer {
    clock_t _start;

  public:
    Timer(): _start(0)
        {
        }

    void TimerReset()
        {   //Reset the clock to current time......
        _start = clock();
        }

    double ElapsedTime()
        {   //return elapsed time in seconds .....
        return (double) ((clock() - _start) / CLOCKS_PER_SEC);
        }
};

#endif

/* ----- EOF --------------------------------------- */
