/* ----------------------------------------------------
 *  Filename:           rtext.c
 *  Summary:            Generate random text file
 *  Author:             T.W. Nelson
 *  Compiler:           BCC++ 4.0
 *  Compile options:
 *  Start date:         27-Nov-1995
 *  Last update:
 *  Version:            1.00
 * ------------------------------------------------- */

#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "ffstream.h"

const int MAXLINE  = 75;
const int MINWORD  = 1;      //minimum "word" length
const int MAXWORD  = 7;      //maximum "word" length
const int MINASCII = 97;     //minimum ascii value  'a'
const int MAXASCII = 122;    //maximum ascii value  'z'
const char datfile[] = "rtext.in";
char linebuf[256];

typedef unsigned long ULINT;
typedef unsigned int  UINT;

int rrange(int lo, int hi)
{   //Returns random# within range lo to hi, inclusive....
    int n = hi - lo + 1;
    return (int) ( ((long) rand() * n)/(RAND_MAX+1) ) + lo;
}

char* makeword( char *dest, int &wlen )
{   char *tmp = dest;
    int len = rrange( MINWORD, MAXWORD );

    for( int i = 0; i < len; i++ )
        *tmp++ = (char) rrange( MINASCII, MAXASCII );

    *tmp++ = ' ';   //add trailing whitespace
    *tmp = '\0';    //and null;
    wlen += strlen(dest);    //accum length of result
    return tmp;
}

int main( int argc, char **argv )
{
    if( argc < 2 )
    {   cout << "Usage: rtext <total# words>\n";
        return 0;
    }

    ffstream ffs( datfile, "w+" );
    ULINT wordlim = atol( argv[1] );
    ULINT wordtot = 0;
    char *pbuf;

    srand( (UINT) time(NULL) );     //initialize

    while( wordtot < wordlim )
    {
        pbuf = linebuf;     //point to start
        int linelen = 0;

        while( wordtot < wordlim )
        {   //fill up line buffer
            pbuf = makeword(pbuf, linelen);
            wordtot++;

            if( linelen >= MAXLINE )
                break;
        }

        strcat( linebuf, "\n" );    //append endofline
        ffs.write( (const void *) linebuf, 1, strlen(linebuf));
    }

    ffs.close();
    cout << "Total #words written = " << wordtot << endl;

    return 0;
}

/* ----- EOF --------------------------------------- */
