/* ----------------------------------------------------
 *  Filename:           ffstream.c
 *  Summary:            iostream-based ffstream implementation
 *  Author:             T.W. Nelson
 *  Compiler:           BCC++ 4.0
 *  Compile options:
 *  Start date:
 *  Last update:
 *  Version:            1.00
 * ------------------------------------------------- */

#if !defined __FSTREAM_H
#include <fstream.h>
#endif

class ffstream : protected fstream  {
  public:
    ffstream(): fstream() { }
    ffstream( const char *name, int mode ) :
              fstream( name, mode ) { }
    virtual ~ffstream() {}
    void open( const char *name, int mode )
        {   fstream::open( name, mode );
        }
    virtual size_t read( void *, size_t sz, size_t n);
    virtual size_t write( const void *, size_t sz, size_t n);
    void close() { fstreambase::close();    }
    int eof() const { return ios::eof();  }
    operator int () { return !ios::fail(); }  //zero on failure
    //int fail() const { return ios::fail(); }  //!zero on failure
    void rewind()
        {   ios::clear();
            fstream::rdbuf()->seekoff( 0, ios::beg, ios::in|ios::out );
        }
};

size_t ffstream::read( void *buf, size_t sz, size_t n )
{  /* Read data in chunks, return #chunks read */
    unsigned char *p = (unsigned char *) buf;
    for( size_t cnt = 0; cnt < n; cnt++ )
    {   read( p, sz );
        if( gcount() < sz || fail() )
            break;
        p += sz;
    }
    return cnt;
}

size_t ffstream::write( const void *buf, size_t sz, size_t n )
{  /* Write data in chunks, return #chunks written */
    const unsigned char *p = (const unsigned char *) buf;
    for( size_t cnt = 0; cnt < n; cnt++ )
    {   write( p, sz );
        if( fail() )
            break;
        p += sz;
    }
    return cnt;
}   /* EOF -------------------  */
