/*
 *  Listing 6   mlist.h
 */

#if !defined __MLIST_H
#define __MLIST_H
#include "mfile.h"
#include "\classlib\dlistimp.h"     //container lib

class MergeList     {
    TIDoubleListImp<MergeFile> *Mp;  // merge list
    TIDoubleListImp<MergeFile> *Ap;  // active list
    TIDoubleListIteratorImp<MergeFile> *Mi, *Ai;
    int _nfiles;  /* #merge files/buffers allocated */
    const size_t _blen;     /* merge buffer length */
  public:
    MergeList( int nfiles,
               const int itemwd, const size_t blen );
    ~MergeList();
    int MergeFileCount() const { return _nfiles;  }
    size_t MergeBufferSize() const { return _blen; }

    int ActiveCount()  const
        { return Ap->GetItemsInContainer(); }
    int PutActive( const MergeFile *p )
        { return Ap->AddAtTail( p );   }
    void RestartActive() const { Ai->Restart();  }
    MergeFile* CurrentActive() const
        { return Ai->Current();  }
    void NextActive() const {  (*Ai)++;  }
    int TestActive() const { return *Ai; }
    int DetachActive( MergeFile *p )
        { return Ap->Detach( p );  }

    int PutHead(const MergeFile *p)
        {   return Mp->AddAtHead( p );  }
    int PutTail(const MergeFile *p)
        {   return Mp->AddAtTail( p );  }
    int GetHead(MergeFile * &p)
        {   p = Mp->PeekHead();
            return Mp->DetachAtHead();  }
    int GetTail(MergeFile * &p)
        {   p = Mp->PeekTail();
            return Mp->DetachAtTail();  }
    MergeFile* PeekHead() const
        {   return Mp->PeekHead();      }
    MergeFile* PeekTail() const
        {   return Mp->PeekTail();      }
    int Test() const { return *Mi; }
    MergeFile* Current() const
        { return (MergeFile *) Mi->Current();  }
    void Next() const {  (*Mi)++;  }
    void Restart() const {  Mi->Restart();   }
};
#endif  // EOF
