/*
 *  Listing 7   mlist.c
 */
#include "mlist.h"

MergeList::MergeList( int nfiles,
const int itemwd, const size_t blen) :
    _nfiles(0), _blen(blen)
{   Mp = new TIDoubleListImp<MergeFile>;
    Ap = new TIDoubleListImp<MergeFile>;
    Mi = new TIDoubleListIteratorImp<MergeFile>(*Mp);
    Ai = new TIDoubleListIteratorImp<MergeFile>(*Ap);
    while( nfiles-- )
    {   MergeFile *p = new MergeFile( itemwd, blen );
        if( !(*p) )    // resource alloc failure
        {   delete p;
            break;
        }
        PutTail(p);
        _nfiles++;
    }
}
MergeList::~MergeList() {
    delete Ap;      //Assumes Ap list is empty
    delete Mi;
    delete Ai;
    MergeFile *p;
    while( GetHead(p) )
        delete p;
    delete Mp;
} // EOF
