/*
 *  Listing 1      ffstream.h
 */

#if !defined __FFSTREAM_H
#define __FFSTREAM_H
#include <stdio.h>

class ffstream
{   FILE    *_fp;
  protected:
    FILE *filep() const { return _fp; }
  public:
    ffstream() : _fp(0) {}
    ffstream( const char *name, const char *mode )
        { open( name, mode ); }
    virtual ~ffstream() { close(); }
    void open( const char *name, const char *mode )
        {   _fp = fopen( name, mode ); }
    virtual size_t read( void *buf,
                         size_t sz, size_t n )
        { return fread( buf, sz, n, _fp );    }
    virtual size_t write( const void *buf,
                          size_t sz, size_t n )
        { return fwrite( buf, sz, n, _fp );   }
    void close() { fclose(_fp); _fp = 0;  }
    int eof() const { return feof(_fp); }
    operator int ()    //assert class invariant
        { return ((_fp != 0) && !ferror(_fp)); }
    void rewind() { ::rewind(_fp); }
};
#endif  // EOF
