// GUITermView.cpp : implementation of the CGUITermView class
//

#include "stdafx.h"
#include "GUITerm.h"

#include "GUITermDoc.h"
#include "GUITermView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGUITermView

IMPLEMENT_DYNCREATE(CGUITermView, CEditView)

BEGIN_MESSAGE_MAP(CGUITermView, CEditView)
	//{{AFX_MSG_MAP(CGUITermView)
	ON_CONTROL_REFLECT(EN_CHANGE, OnChange)
	ON_WM_CHAR()
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	//}}AFX_MSG_MAP

    ON_MESSAGE(WM_COMMDATA, OnCommData)

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGUITermView construction/destruction

CGUITermView::CGUITermView()
{
	// TODO: add construction code here

}

CGUITermView::~CGUITermView()
{
}

BOOL CGUITermView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	BOOL bPreCreated = CEditView::PreCreateWindow(cs);
	cs.style &= ~(ES_AUTOHSCROLL|WS_HSCROLL);	// Enable word-wrapping

	return bPreCreated;
}

/////////////////////////////////////////////////////////////////////////////
// CGUITermView drawing

void CGUITermView::OnDraw(CDC* pDC)
{
	CGUITermDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CGUITermView diagnostics

#ifdef _DEBUG
void CGUITermView::AssertValid() const
{
	CEditView::AssertValid();
}

void CGUITermView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}

CGUITermDoc* CGUITermView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CGUITermDoc)));
	return (CGUITermDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGUITermView communication functions

// wParam = size of block, lParam = pointer to the data
LONG CGUITermView::OnCommData(WPARAM wParam, LPARAM lParam)
{
    char byBuffer[1024], *byData = (char *)lParam;
    int  nSelStart, nSelEnd, nLen;

    CEdit &eCtrl = GetEditCtrl();
    nLen = eCtrl.SendMessage(WM_GETTEXTLENGTH, 0, 0);
    eCtrl.GetSel(nSelStart, nSelEnd);

    // If the cursor is not at the end, move it
    if(nSelStart != nSelEnd || nSelStart != nLen)
        eCtrl.SetSel(nLen + 1, nLen + 1, TRUE);

    // Parse the data for special characters and handle them
    // accordingly.
    while(wParam)
    {
        nLen = 0;
        while(wParam && nLen < sizeof(byBuffer) - 3)
        {
            byBuffer[nLen++] = *byData;

            switch(*byData)
            {
                case '\r':      // Add line feed?
                    if(wParam == 1 || *(byData + 1) != '\n')
                        byBuffer[nLen++] = '\n';
                    break;

                case '\n':      // Add carriage return?
                    if(nLen == 1 || *(byData - 1) != '\r')
                    {
                        byBuffer[nLen - 1] = '\r';
                        byBuffer[nLen++] = '\n';
                    }
                    break;

                case '\a':      // Bell
                    nLen--;
                    MessageBeep(0xFFFFFFFF);
                    break;

                case '\b':      // Backspace
                    nLen--;
                    byBuffer[nLen] = '\x0';

                    // Insert what we've got (if any)
                    if(nLen)
                        eCtrl.ReplaceSel(byBuffer);

                    // Now "backspace" by erasing the last character.
                    // This'll handle backing up to the end of the
                    // previous line.
                    nLen = eCtrl.SendMessage(WM_GETTEXTLENGTH, 0, 0);
                    eCtrl.SetSel(nLen - 1, nLen, TRUE);
                    eCtrl.Clear();
                    nLen = 0;
                    break;

                default:
                    break;
            }

            byData++;
            wParam--;
        }

        if(nLen)
        {
            byBuffer[nLen] = '\x0';
            eCtrl.ReplaceSel(byBuffer);
        }
    }

    return 0L;
}

/////////////////////////////////////////////////////////////////////////////
// CGUITermView message handlers

void CGUITermView::OnInitialUpdate()
{
    // Use a standard fixed font
    SetFont(CFont::FromHandle((HFONT)::GetStockObject(OEM_FIXED_FONT)),
        FALSE);
	CEditView::OnInitialUpdate();
}

void CGUITermView::OnChange()
{
    // Nothing to edit, so ignore changes.
}

void CGUITermView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    // Pass keyboard input directly on to the document
    while(nRepCnt--)
        GetDocument()->SendChar(nChar);
}

void CGUITermView::OnEditPaste()
{
    HGLOBAL hClip;
    LPSTR pszText;
    int nLen;

    if(OpenClipboard())
    {
        hClip = GetClipboardData(CF_OEMTEXT);
        if(hClip)
        {
            pszText = (LPSTR)GlobalLock(hClip);
            nLen = strlen(pszText);
            GetDocument()->SendBlock(pszText, nLen);

            GlobalUnlock(hClip);
        }

        CloseClipboard();
    }
}
