// GUITermDoc.h : interface of the CGUITermDoc class
//
/////////////////////////////////////////////////////////////////////////////

#define WM_COMMDATA     WM_USER + 500       // User-defined COMM event
#define MAX_SIZE        1024                // Max size of read buffer

class CSerialPort;
class CGUITermDoc;

// This structure gets passed to the standard terminal thread.  It
// contains a pointer to the port and the document objects
struct GUITermData
{
    CSerialPort *COMPort;
    CGUITermDoc *TermDoc;
};

//=============================================================================

class CGUITermDoc : public CDocument
{
protected: // create from serialization only
	CGUITermDoc();
	DECLARE_DYNCREATE(CGUITermDoc)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGUITermDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CGUITermDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CGUITermDoc)
	afx_msg void OnFileSettings();
	afx_msg void OnUpdateFileConnect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileDisconnect(CCmdUI* pCmdUI);
	afx_msg void OnFileConnect();
	afx_msg void OnFileDisconnect();
	afx_msg void OnFileXreceive();
	afx_msg void OnFileXsend();
	afx_msg void OnUpdateFileXreceive(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileXsend(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
    CSerialPort *COMPort;
    GUITermData TermData;

	CString	m_csPort;
	CString	m_csParity;
	CString	m_csBaudRate;
	CString	m_csDataBits;
	CString	m_csFlowControl;
	CString	m_csStopBits;
	BOOL	m_bLocalEcho;
    BOOL    m_bSendCRLF;

    // Thread function
    static DWORD WINAPI CommReader(void *pvData);

public:
    BOOL SendChar(char chChar);
    BOOL SendBlock(const char *byData, int nSize);
    void ReceiveChars(const char *byBuffer, int nSize);

    BOOL XModemSend(const char *szFilename);
    BOOL XModemReceive(const char *szFilename);
};

/////////////////////////////////////////////////////////////////////////////
