	.386p
	.model small

include  prints.ase 
include  mtrap.ase 
include  input.ase 
include  dis.ase 

	PUBLIC	DisplayRegisters, ModifyRegisters
	extrn put_msg : proc

	.data
;
; This is a list corresponding ASCII names for general purpose regs
; with the address the value can be found at;
;
peax	dd	offset DGROUP:dreax
	db	10,"eax:",0
pebx	dd	offset DGROUP:drebx
	db	"ebx:",0
pecx	dd	offset DGROUP:drecx
	db	"ecx:",0
pedx	dd	offset DGROUP:dredx
	db	"edx:",0
pesi	dd	offset DGROUP:dresi
	db	"esi:",0
pedi	dd	offset DGROUP:dredi
	db	"edi:",0
pebp	dd	offset DGROUP:drebp
	db	10,13,"ebp:",0
pesp	dd	offset DGROUP:dresp
	db	"esp:",0
peip	dd	offset DGROUP:dreip
	db	"eip:",0
	dd	0
peflags	dd	offset DGROUP:reflags
	db	"eflags:",0
regPrompt db	10,": ",0

	.code
;
; Print a general purpose reg and it's value
;
PutDword	PROC	
	lodsd			; Get pointer to val
	mov	eax,[eax]	; Get val
	push	eax		;
	mov	ebx,esi		; Get text pointer
	call	put_msg
	pop	eax		;
	call	printdword	; Print value
	call	printspace	;
	ret
PutDword	ENDP	
;
; Print either the GP regs or the SEG regs
;

PrintAFew	PROC	
	call	edx		; Call the print routine
pf_lp:
	lodsb			; Wade past the text
	or	al,al		;
	jnz	pf_lp		;
	test	DWORD PTR [esi],-1 ; See if trailer found
	jnz	PrintAFew	; Go print another
	ret
PrintAFew	ENDP	
;
; Read value for a register
;
ReadReg	PROC	
rr2:
	mov	edi,ebx			; Point at list
	test	DWORD PTR [edi],-1	; See if found trailer
	jz	short rr_notfound 	; Quit if so
	add	edi,4			; Skip past value
	cmp	BYTE PTR [edi],10	; Skip past line feed, if exists
	jnz	short notlf		;
	inc	edi			;
notlf:
	push	ecx			; Compare specified reg name to list
	push	esi			;
	repe	cmpsb			;
	pop	esi			;
	pop	ecx			;
	jz	short rr_got		; Got it
	add	ebx,4			; Else skip past value
rr_wade:
	inc	ebx			; Skip past name
	test	BYTE PTR [ebx-1],-1	;
	jnz	rr_wade			;
	jmp	rr2			; Check next name
rr_got:
	add	esi,ecx         	; Point after reg name
	call	WadeSpace		; Wade through spaces
	cmp	al,13			; Don't prompt if input is here
	jnz	gotinput		;
	push	ebx			; Else put up prompt
	push	ecx			;
	mov	ebx,offset regPrompt
	call	put_msg
	call	GetInputLine		; Get input line
	pop	ecx			;
	pop	ebx			;
	call	WadeSpace		; Ignore spaces
	cmp	al,13			; See if CR
	jz	short rr_out		; Quit if so
gotinput:
	mov	ebx,[ebx]		; Get pointer to addres
	call	ReadNumber		; Read number
	jc	rr_notfound		; Error if bad number
	mov	[ebx],eax		; Else just save offset
rr_out:
	clc				; Get out no errors
	ret
rr_notfound:
	stc				; Get out, errors
	ret

ReadReg	ENDP	
;
; main 'Reg' command
;
ModifyRegisters	PROC	
	call	WadeSpace		; Wade through spaces
	cmp	al,13			; If CR
	jz	short DisplayRegisters	; Display regs
	push	esi
	sub	ecx,ecx			; Point at text-1
	dec 	ecx
	dec	esi			;
cloop:
	inc	esi 			; Next text
	inc	ecx			; Next count
	mov	al,[esi]		; Get char
	cmp	al,13			; IF CR or SPACE
	jz	short gotend		;
	cmp	al,' '			;
	jnz	short cloop		;
gotend:
	pop	esi
	cmp	cl,3			; If not 3
	jnz	badreg			; Bad reg name
	mov	ebx,offset peax		; Read in a general purpose reg
	call	ReadReg			;
	jmp	short gotdata		;
badreg:
	stc				; Error
gotdata:
	ret
ModifyRegisters	ENDP	
;
; Display the processor regs
;
DisplayRegisters	PROC	
	mov	esi, offset peax	; Print GP regs
	mov	edx,offset PutDword	; with the DWORD function
	call	PrintAFew		; Print them
	mov	esi,offset DGROUP:peflags	; Put the flags
	call    PutDword		;
	mov	ebx,[dreip]		; Dissassemble at current code pointer
	call	DisOneLine		;
	clc
	ret
DisplayRegisters	ENDP	
END