	.386p
	.model small

include  prints.ase 
include  input.ase 
include  mtrap.ase 
include  breaks.ase 

TRAPFLAG = 100h			; 80386 trap enable flag

	PUBLIC go,trap, proceed

	.data
	extrn dres:word, drds:word
	.code
;
; Wade through spaces only
;
WadeSpaceOnly	PROC	
	lodsb			; Get a char
	cmp	al,' '		; Is space
	jz	WadeSpaceOnly	; Loop if so
	dec	esi		; Else point at char
	ret
WadeSpaceOnly	ENDP	
;
; Execute program
;
go	PROC	
	Call	WadeSpaceOnly	; Wade till address
	cmp	al,13		; CR means from this point on
	jz	short dogo	; Do it from this EIP if CR
	inc	esi		; See if is a comma
	cmp	al,','		;
	jz	short dobreak	; Only a breakpoint if so
	dec	esi		; Get the execution point
	call	ReadAddress	;
	jc	goerr		;
	mov	[dreip],ebx	; Fix CS:EIP for new routine
checkbreak:
	call	WadeSpaceOnly	; Wade
	cmp	al,13		; execute if CR
	jz	short dogo	;
	cmp	al,','		; Check for comma
	jnz	goerr		; Error if not a comma
	inc	esi		; Wade to address
	call	WadeSpaceOnly
dobreak:
	call	ReadAddress	; Read break address
	jc	goerr		; Quit if errir
	sub	eax,eax		; Break 0
	call	setbreak	; Set the break
dogo:
	call	enablebreaks	; Enable breaks
	xor	eax,eax		; Not trapping
	jmp	short gotrap	; Run the code
go	ENDP	
;
; Limited procede, only traps through near and far direct calls,
; interrupts, and near calls through a register
;
proceed	PROC	
	mov	ebx,[dreip]	;
	mov	ah,[ebx]	; Load the first byte of the instruction
	cmp	ah,0e8h		; Near Call?
	mov	al,5		; Yes, this is five bytes
	jz	short pgo	; And execute it
	cmp	ah,09ah		; Far call
	mov	al,7		; This one is 7 bytes
	jz	short pgo	; And execute it
	cmp	ah,0cdh		; Interrupt ?
	mov	al,2		; two bytes
	jz	short pgo	; and execute it
	cmp	ah,0ceh		; int0?
	mov	al,1
	jz	short pgo
	mov	ax,[ebx]	; now check for near call through reg
	and	ax,0f8ffh	;
	cmp	ax,0d0ffh	;
	mov	al,2		; two bytes
	jnz	short trap	; Not either of these, just trap
pgo:
	cbw			; EAX = bytes to skip past
	cwde			;
	add	ebx,eax		; Ebx = breakpoint
	sub	eax,eax		; Use the scratch breakpoint
	call	setbreak	; Set a break
	call	enablebreaks	; Enable breakpoints
	sub	eax,eax		; No trapping
	jmp	short gotrap	; Run the code
proceed	ENDP	
;
; Trap command
;
trap	PROC	
	mov	eax,TRAPFLAG	; Are trapping on instruction
gotrap:
	mov	esp,[dresp]
	or	eax,[reflags]	; Fill stack frame with FLAGS , CS:EIP
	push	eax		;
	mov	ebx,cs	;
	push	ebx		;
	push	[dreip]		;
	movzx	eax,[drds]
	push	eax
	mov	es,[dres]
	mov	eax,[dreax]	; Load regs
	mov	ebx,[drebx]	;
	mov	ecx,[drecx]	;
	mov	edx,[dredx]	;
	mov	esi,[dresi]	;
	mov	edi,[dredi]	;
	mov	ebp,[drebp]	;
	pop	ds		; Load DS
	iretd
goerr:
	stc
	ret
trap	ENDP	
end