#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <stdarg.h>
#include <time.h>
#include <libp.h>


static void search(char *dest, const char *source)
{
	char *path = getenv("PATH"),buf[128],*p=path,*q;
	FILE *t;
	t = fopen("source","rb");
	if (t) {
		fclose(t);
	}
	else while (*p) {
		q = buf;
		while (*p != ';' && *p)
			*q++=*p++;
		if (*p) p++;
		if (*(q-1) != '\\')
			*q++ = '\\';
		strcpy(q,source);
		if ((t = fopen(buf,"rb")) != 0) {
			fclose(t);
			strcpy(dest,buf);
			return;
		}
	}
	strcpy(dest,source);
	return;

}
static int spawnbase(const char *path, const char *args[], 
										 const char *env[], int toexit, int tosearch)
{
  int rv;
	char name[128];
	char parms[500];
	parms[0] = 0;
	if (env)
		printf("Warning: RTL does not support environment-passing spawn/exec\n");
	while (*args)
		strcat(parms,*args++);
	if (tosearch && !strchr(path,'\\') && !strchr(path,':'))
		search(name,path);
	else
		strcpy(name,path);
	rv = _ll_spawn(name,parms,env);
	if (toexit)
		exit(rv);
	return rv;
}
static char **findenv(const char **argv)
{
	char *vv;
	vv = argv;
	while (*vv)
		vv++;
	return (++vv);
}
int execl(const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,0,1,0);
}
int execle(const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,findenv(&argv0),1,0);
}
int execlp(const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,0,1,1);
}
int execlpe(const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,findenv(&argv0),1,1);
}
int execv(const char *path, const char **argv)
{
	return spawnbase(path,&argv,0,1,0);
}
int execve(const char *path, const char **argv, const char **env)
{
	return spawnbase(path,argv,env,1,0);
}
int execvp(const char *path, const char **argv)
{
	return spawnbase(path,argv,0,1,1);
}
int execvpe(const char *path, const char **argv, const char **env)
{
	return spawnbase(path,argv,env,1,1);
}
int spawnl(int mode,const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,0,mode,0);
}
int spawnle(int mode,const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,findenv(&argv0),mode,0);
}
int spawnlp(int mode,const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,0,mode,1);
}
int spawnlpe(int mode,const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,findenv(&argv0),mode,1);
}
int spawnv(int mode,const char *path, const char **argv)
{
	return spawnbase(path,&argv,0,mode,0);
}
int spawnve(int mode,const char *path, const char **argv, const char **env)
{
	return spawnbase(path,argv,env,mode,0);
}
int spawnvp(int mode,const char *path, const char **argv)
{
	return spawnbase(path,argv,0,mode,1);
}
int spawnvpe(int mode,const char *path, const char **argv, const char **env)
{
	return spawnbase(path,argv,env,mode,1);
}