// This JavaScript remote-control search engine interface
// was written by Curtis Autery on June 24, 1997
// as a modification of a previous interface by Curtis Autery.
// This document is in the public domain and can be used for
// helping to learn JavaScript by example. Cut and paste at will,
// but leave this notice intact as a courtesy. Thank you.


// First a note : This is not written as a JavaScript reference. It can be used
// for some examples of organizing JavaScript concepts to those already
// thoroughly familiar with the language.


// As this is a remote control box, I want it to stay on top in some circumstances,
// but not in others. I'll start by declaring a global variable outside of the
// main functions.
keepfocus=1



// This is the basic remote control opener function. It opens a 200x100 window with
// no "extras" like toolbars or scrollbars, and is a fixed size that cannot be resized
// (although it can be maximized, but there's no point in that). The document.clear function
// only works in Netscape 3 and above (and IE 3, I think, but I wouldn't try using this
// in any other version of IE except IE4), so this will not work in Netscape 2.x. I am
// using the document.clear function just in case the load function gets called twice so the
// text that I'm sending to the window won't be sent twice.
function rcopen() {
keepfocus=1;
rcbox=window.open("", "info","resizable=0,toolbar=0,menubar=0,scrollbars=0,width=200,height=100");
rcbox.document.clear();
rcbox.focus();
rcbox.opener.name="orig";

// Note that I has to break up <scr and ipt>. JavaScript will have a cow
// if you try to send a direct script tag to another window. The source for the RC
// window will be this document. If you modify this document and save it under a new
// name, be sure to modify the following line accordingly.
rcbox.document.write("<head><scr"+"ipt src=remote.js></script>");

// Title's the window and turns focus to "always on" when window get focus,
// as well us checking to see if focus should be returned whenever focus goes
// to another item (onBlur). Note my use of a timer here. This is so that
// I have time to turn off the auto-focus when items in the RC window are
// selected. This was a major pain to get setup properly
rcbox.document.write("<title>Remote Control</title></head><body onfocus='wax()' onblur=\"timerID=setTimeout('dofocus()',50)\">");
}


// The following section is all the focus related commands. DoFocus checks to see
// if focus should be returned. Wain turns off auto-focus, Wax turns it on.

function dofocus(){
if (keepfocus==1) 
{window.focus();}
}

function wain(){keepfocus=0;}
function wax(){keepfocus=1;}

// FocusOn turns on auto-focus AND returns the RC focus in one command.
// ReturnControl does the opposite, turning auto-focus off and returning focus to the
// main web page

function focuson(){keepfocus=1;window.focus()}
function returncontrol(){keepfocus=0;opener.focus();}


// A timesaving "alias" function so that I don't have to type "rxbox.document.write"
// everytime I want to send text to the RC box.
function rc(text) {
rcbox.document.write (text);
}

// Puts the "Hide" button on the bottom of the form that gets rid of the RC
// box so that the user can manipulate the destination page.
// bringing the RC box back up will return the auto-focus property until Hide
// is pressed again
function button(){
rc("<input type=button value=Hide onclick='returncontrol()'></center><br>");
rc("</form></html>");
}


// This function directs the main "opener" page to the search engine of choice using
// the entered terms from one of the functions below
function go(terms){
focuson();
opener.location.href=("http://"+terms);
}

// Below are the functions describing the syntax of each individual search engine.
// These change, and so do the URLs. These were accurate as of the date of this
// file's creation

function yahoo(terms) {
go("search.yahoo.com/bin/search?p="+terms)}

function webcrawler(terms) {
go("www.webcrawler.com/cgi-bin/WebQuery?searchText="+terms)}

function lycos(terms) {
go("www.lycos.com/cgi-bin/pursuit?query="+terms)}

function alta(terms) {
go("www.altavista.digital.com/cgi-bin/query?pg=q&what=web&q="+terms)}

function hotbot(terms) {
go("www.hotbot.com/?MT="+terms)}

function excite(terms) {
go("www.excite.com/search.gw?search="+terms)}

function magellan(terms) {
go("www.mckinley.com/searcher.cgi?query="+terms)}

function infoseek(terms) {
go("www.infoseek.com/Titles?sv=IS&lk=noframes&nh=10&qt="+terms)}

function metacrawler(terms) {
go("www2.metacrawler.com/cgi-bin/nph-metaquery?method=0&sort=relevance&ltarget=window&useFrames=1&iface=int1&general="+terms)}

function savvy(terms) {
go("rampal.cs.colostate.edu:2000/search?KW="+terms)}



// A quick function determining which item of the selector was chosen. This will forward
// the search terms to the appropriate engine function above
function search(engine,terms){
focuson();
if (engine==0) yahoo(terms);
else if (engine==1) webcrawler(terms);
else if (engine==2) lycos(terms);
else if (engine==3) alta(terms);
else if (engine==4) hotbot(terms);
else if (engine==5) excite(terms);
else if (engine==6) magellan(terms);
else if (engine==7) infoseek(terms);
else if (engine==8) metacrawler(terms);
else if (engine==9) savvy(terms);
else if (engine>=10) direct(engine);
}
// If the selector was set to the bottom entry, "Delirium's Homepage", then
// a special function is called. More items can be added to this. If you want to add your
// homepage to the list, add "else if (engine==11) mypage();" to the Direct function,
// then create a function "function mypage()" similar to the Delirium function below
function direct(engine){
if (engine==10) delirium();
}

function delirium(){go("ourworld.compuserve.com/homepages/delirium")}



// This is the main function that is called from the rc.htm file when it is opened.
// This will call the RC box open function, and send some HTML code to it.
function doit(){
rcopen();
rc("<body bgcolor=black>");
rc("<form name=selector action=\"javascript:search(document.selector[0].selectedIndex,escape(document.selector[1].value))\" method=post>");
rc("<select name=\"engine\" onfocus='wain()' onchange='focuson()' onblur='dofocus()'>");
rc("<option value=0>Yahoo");
rc("<option value=1 SELECTED>Webcrawler");
rc("<option value=2>Lycos");
rc("<option value=3>Alta-Vista");
rc("<option value=4>Hotbot");
rc("<option value=5>Excite");
rc("<option value=6>Magellan");
rc("<option value=7>Infoseek");
rc("<option value=8>Metacrawler");
rc("<option value=9>Savvy Search");
rc("<option value=10>Delirium's Homepage");
rc("</select>");
rc("<br><input type=text name=\"terms\" value=\"\" size=20 onfocus='wain()' onchange='focuson()' onblur='dofocus()'>");
rc("<br><input type=submit value=Go> ");
button();
}