
#include <windows.h>
#include "zangmem.h"

HANDLE hMapObject = 0;

//
// ZanMemAlloc 
//
void* ZanMemAlloc (int iSize)
{
	if (hMapObject)
		return NULL;	// Allow only one view per process

	hMapObject = CreateFileMapping ((HANDLE)0xFFFFFFFF,
		NULL,
		PAGE_READWRITE,
		0,
		sizeof CZanGMem,
		"CZanGMemShared");

	if (!hMapObject)
		return NULL;

	return MapViewOfFile (hMapObject, FILE_MAP_WRITE, 0, 0, 0);
}


//
// ZanMemFree
//
void ZanMemFree (void *pvFree)
{
	UnmapViewOfFile (pvFree);

	CloseHandle (hMapObject);
}


//
// Constructor
//
CZanGMem::CZanGMem ()
{
	iProcessCnt++;
}


//
// Destructor
//
CZanGMem::~CZanGMem()
{
	iProcessCnt--;
}
































