Public Sub SetAllowBypassKey(bBypass As Boolean)
'**************************************************************************
' Sub SetAllowBypassKey(bBypass As Boolean)                      Access 97
'
' Sets the AllowBypassKey property of the Properties collection of
' the current database to either True or False.  Takes effect the next
' time the database is opened.
'**************************************************************************
Dim dbs As Database, prp As Property
Const conPropNotFoundError = 3270     'Occurs if the property doesn't exist
Const strKey = "AllowBypassKey"       'Our property name
Set dbs = CurrentDb                   'Set object to the current database
On Error GoTo SetAllowBypassKeyErr    'Specify error handler
If bBypass = False Then
   dbs.Properties(strKey) = False     'Set AllowBypassKey to False
Else
   dbs.Properties(strKey) = True      'Set AllowBypassKey to True (default)
End If

SetAllowBypassKeyExit:
   Exit Sub

SetAllowBypassKeyErr:
   If Err = conPropNotFoundError Then  ' Property doesn't exist yet
      If bBypass = False Then          ' Create the property
         Set prp = dbs.CreateProperty(strKey, dbBoolean, False)
      Else
         Set prp = dbs.CreateProperty(strKey, dbBoolean, True)
      End If
      dbs.Properties.Append prp        ' Add it to the collection
      Resume SetAllowBypassKeyExit
   End If

End Sub

