unit send;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,winsock, StdCtrls, ExtCtrls;

const
     WriteMyMsg   =  WM_USER + 101;   {assign identifier for FD_WRITE event notification}

type
  TForm1 = class(TForm)
    StartSendingButton: TButton;
    StopSendingButton: TButton;
    Button3: TButton;
    Timer1: TTimer;
    SendMessageButton: TButton;
    ExitButton: TButton;
    memo1: TMemo;
    label1: TLabel;
    procedure StartSendingButtonClick(Sender: TObject);
    procedure StopSendingButtonClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure SendMessageButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
    procedure Swriter(var Msg : TMessage); message WriteMyMsg; {message handler for FD_WRITE}
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  s                 :      Tsocket;
  wsaData           :       tWSADATA;
  sendbuf           :       array[0..200] of char;
  verreq            :       wordrec;
  ii                :       integer;
  addr, bddr        :       TsockAddrIn;
  tolen, nbytes, getWsa :       integer;
  flag              :      integer;
  writeready        :      boolean;
  mywindow          :      hWnd;
  timetostop        :      boolean;

implementation

{$R *.DFM}

procedure TForm1.StartSendingButtonClick(Sender: TObject);

var
   st     :      string;

begin

if flag = 1 then
begin
messagedlg('Already Sending', mtInformation, [mbOK], 0);
timer1.enabled := true;
exit
end;

   with verreq do             {Requires Winsock 1.1}
        begin
             hi := 1;
             lo := 1;
        end;

writeready := false;
getWsa := WSAStartup(Word(verreq), wsaData);

s := socket(AF_INET, SOCK_DGRAM, 0);

{We will be broadcasting on port 2221 to all machines}
{listening on port 2222 - even on same machine!}

bddr.sin_family := AF_INET;
bddr.sin_port   := htons(2221);
bddr.sin_addr.s_addr := htonl(INADDR_ANY);

ii := bind(s, bddr, sizeof(bddr));

if ii <> 0 then
begin
messagedlg(inttostr(ii), mtInformation, [mbOK], 0);
   ii := wsaGetLastError;
messagedlg('bind error = ' + inttostr(ii), mtInformation, [mbOK], 0);
end;

addr.sin_family := AF_INET;
addr.sin_port   := htons(2222);
addr.sin_addr.s_addr := htonl(INADDR_BROADCAST);

nbytes :=SO_BROADCAST;
tolen := sizeof(nbytes);

ii := setsockopt(s, SOL_SOCKET, SO_BROADCAST, pchar(@nbytes), tolen);
{Sets socket option to enable broadcast...}

if ii <> 0 then
begin
messagedlg(inttostr(ii), mtInformation, [mbOK], 0);
ii := wsaGetLastError;
messagedlg('setsocket error = ' + inttostr(ii), mtInformation, [mbOK], 0);
end;

ii := strlen(sendbuf);
mywindow := form1.handle;
timetostop := false;
ii := WSAAsyncSelect(s, mywindow, WriteMyMsg, FD_WRITE);

    {Registers an interest in the FD_WRITE event, so that a WriteMyMsg}
    {message will be sent to this window}

timer1.enabled := true;
flag := 1;
end;


procedure TForm1.SWriter(var MSG : TMessage);

var
   str    :    string;

begin
     {if notified that it is OK to write to the port, and}
     {it is not time to stop, then set writeready flag for}

     If loword(msg.lParam) = FD_WRITE then
      begin
        if not timetostop then writeready := true
        else
        writeready := false;
      end;
end;

procedure TForm1.StopSendingButtonClick(Sender: TObject);

var
   xx     :   word;

begin

if flag = 0 then
begin
messagedlg('Not Currently Sending', mtInformation, [mbOK], 0);
exit
end;

timetostop := true;
writeready := false;
timer1.enabled := false;
xx := closesocket(s);
if xx <> 0 then
begin
  messagedlg(inttostr(xx), mtInformation, [mbOK], 0);
  xx := wsaGetLastError;
  messagedlg('WSA error = ' + inttostr(xx), mtInformation, [mbOK], 0);
end
else
  WSACleanup;
  flag := 0;
end;

procedure TForm1.Timer1Timer(Sender: TObject);

var
   st   :  string;

begin

if ((not writeready) or timetostop) then exit;
st:= DateTimeToStr(Now);
StrPLCopy(sendbuf, st, 201);
ii := strlen(sendbuf);
ii := sendto(s, sendbuf, ii+1, 0, addr, sizeof(addr));   {broadcast the time}
sendbuf[0] := #0;
end;


procedure TForm1.SendMessageButtonClick(Sender: TObject);
var
   st     :      string;

begin

if flag = 0 then
begin
messagedlg('Not Currently Sending', mtInformation, [mbOK], 0);
exit
end;

timer1.enabled := false;
st := memo1.lines[0];
ii := 1;
while memo1.lines[ii] <> '' do
begin
st := st + ' ' + memo1.lines[ii];
ii := ii +1;
end;
sendbuf[0] := #0;
StrPLCopy(sendbuf, 'x' + st, 200);  {start with an x to indicate message rather than time}
ii := strlen(sendbuf);
ii := sendto(s, sendbuf, ii+1, 0, addr, sizeof(addr));   {broadcast message}
sendbuf[0] := #0;
memo1.clear;
timer1.enabled := true;
end;


procedure TForm1.ExitButtonClick(Sender: TObject);

var
   xx     :   integer;
   st     :   string;
begin

timetostop := true;
writeready := false;
timer1.enabled := false;

if flag = 1 then
begin
ii := wsacancelblockingcall;
ii := wsagetlasterror;
closesocket(s);
wsacleanup;
end;
st := 'Thank you for trying the BROADCAST test program' + chr(13) + chr(10);
st := st + chr(13) + chr(10) + 'Harry M. Pierson, Ph.D.' + chr(13) + chr(10);
st := st +  'DREJ Consulting' + chr(13) + chr(10);
st := st + '914-428-8070';
messagedlg(st , mtInformation, [mbOK], 0);
button3.click
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
form1.memo1.lines[0] := '';
flag := 0;
writeready := false;
timetostop := false;
memo1.clear;
end;


procedure TForm1.Button3Click(Sender: TObject);
begin
release;
application.terminate;
end;

end.
